<?php

class Architek_Socials_Widget extends WP_Widget {
	function __construct() {
		$widget_ops = array('classname' => 'architek_socials_widget', 'description' => esc_html__('Display Social Icons', 'architek'));
		parent::__construct(false, 'UPPER _ Social Icons', $widget_ops);
	}
	
	function form($instance) {
		if (isset($instance['title'])){
			$title = esc_attr($instance['title']); 
		} else $title = "";
		if (isset($instance['iconsize'])){
			$iconsize = esc_attr($instance['iconsize']);
		} else $iconsize = 16;
		if (isset($instance['align'])){
			$align = esc_attr($instance['align']);
		} else $align = "left";
		if (isset($instance['color'])){
			$color = esc_attr($instance['color']);
		} else $color = "#000000";
		if (isset($instance['colorHover'])){
			$colorHover = esc_attr($instance['colorHover']);
		} else $colorHover = "#".get_option('architek_style_color', 'a1a1a1');
		if (isset($instance['usePanelOptions'])){
			$usePanelOptions = esc_attr($instance['usePanelOptions']);
		} else $usePanelOptions = "yes";
		
		$socials = ["facebook", "twitter", "tumblr", "stumbleupon", "flickr", "linkedin", "delicious", "skype", "digg", "vimeo-square", "deviantart", "behance", "instagram", "blogger", "wordpress", "youtube", "reddit", "rss", "soundcloud", "pinterest", "dribbble"];
		$socials_labels = ["Facebook", "Twitter", "Tumblr", "StumbleUpon", "Flickr", "LinkedIn", "Delicious", "Skype", "Digg", "Vimeo", "DeviantArt", "Behance", "Instagram", "Blogger", "WordPress", "Youtube", "Reddit", "RSS", "SoundCloud", "Pinterest", "Dribbble"];
		foreach ($socials as $social){
			if (isset($instance[$social])){
				$$social = esc_attr(esc_url($instance[$social]));
			} else $$social = "";
		}
		
		?>
		<div class="architek_socials_widget <?php echo esc_attr( $this->id ); ?>">
			<p><label for="<?php echo esc_attr($this->get_field_id('title')); ?>">&#8212; <?php esc_html_e('Widget Title','architek'); ?> &#8212;<input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_html($title); ?>" ></label></p> 
			
			<p class="widget-option-container-title"><label><strong><?php esc_html_e('Style Options','architek'); ?></strong></label></p>
			<p class="widget-option-container"><label for="<?php echo esc_attr($this->get_field_id('iconsize')); ?>">&#8212; <?php esc_html_e('Icon Size (px)','architek'); ?> &#8212;<input class="smaller-option" id="<?php echo esc_attr($this->get_field_id('iconsize')); ?>" name="<?php echo esc_attr($this->get_field_name('iconsize')); ?>" type="number" value="<?php echo esc_attr($iconsize); ?>" min="1" /></label></p>
			<p class="widget-option-container"><label for="<?php echo esc_attr($this->get_field_id('align')); ?>">&#8212; <?php esc_html_e('Alignment','architek'); ?> &nbsp;
				<select class="smaller-option align" id="<?php echo esc_attr($this->get_field_id('align')); ?>" name="<?php echo esc_attr($this->get_field_name('align')); ?>" >
					<option value="left" <?php if ($align == "left") echo "selected"; ?> ><?php _e('Left', 'architek'); ?></option>
					<option value="center" <?php if ($align == "center") echo "selected"; ?> ><?php _e('Center', 'architek'); ?></option>
					<option value="right" <?php if ($align == "right") echo "selected"; ?> ><?php _e('Right', 'architek'); ?></option>
				</select>
			</p>
			<p class="widget-option-container"><label for="<?php echo esc_attr($this->get_field_id('color')); ?>">&#8212; <?php esc_html_e('Color','architek'); ?> &#8212;<input class="smaller-option" id="<?php echo esc_attr($this->get_field_id('color')); ?>" name="<?php echo esc_attr($this->get_field_name('color')); ?>" type="color" value="<?php echo esc_attr($color); ?>" /></label></p>
			<p class="widget-option-container"><label for="<?php echo esc_attr($this->get_field_id('colorHover')); ?>">&#8212; <?php esc_html_e('Color Hover','architek'); ?> &#8212;<input class="smaller-option" id="<?php echo esc_attr($this->get_field_id('colorHover')); ?>" name="<?php echo esc_attr($this->get_field_name('colorHover')); ?>" type="color" value="<?php echo esc_attr($colorHover); ?>" /></label></p>
			
			<p class="widget-option-container-title"><label><strong><?php esc_html_e('Social Networks','architek'); ?></strong></label></p>
			<p class="widget-option-container"><label for="<?php echo esc_attr($this->get_field_id('usePanelOptions')); ?>">&#8212; <?php esc_html_e('Use Panel Options','architek'); ?> &nbsp;
				<select class="smaller-option custom-socials-widget-select" id="<?php echo esc_attr($this->get_field_id('usePanelOptions')); ?>" name="<?php echo esc_attr($this->get_field_name('usePanelOptions')); ?>" >
					<option value="yes" <?php if ($usePanelOptions == "yes") echo "selected"; ?> ><?php _e('Yes', 'architek'); ?></option>
					<option value="no" <?php if ($usePanelOptions == "no") echo "selected"; ?> ><?php _e('No', 'architek'); ?></option>
				</select>
			</p>
			
			<div <?php if ($usePanelOptions == "yes") echo 'hidden' ?> class="custom-socials-group">
				<p class="widget-option-container-title"><label><strong><?php esc_html_e('Custom Networks','architek'); ?></strong></label></p>
				<?php
					foreach($socials as $key => $social){
						?>
						<p><label for="<?php echo esc_attr($this->get_field_id($social)); ?>">&#8212; <?php esc_html_e( $socials_labels[$key] ,'architek'); ?> &#8212;<input class="widefat" id="<?php echo esc_attr($this->get_field_id($social)); ?>" name="<?php echo esc_attr($this->get_field_name($social)); ?>" type="text" value="<?php echo esc_html($$social); ?>" ></label></p> 
						<?php
					}
				?>
			</div>
			<p class="options-clear"></p>
		</div>
		<?php
	}
	
	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['iconsize'] = $new_instance['iconsize'];
		$instance['align'] = $new_instance['align'];
		$instance['color'] = $new_instance['color'];
		$instance['colorHover'] = $new_instance['colorHover'];
		$instance['usePanelOptions'] = $new_instance['usePanelOptions'];
		$socials = ["facebook", "twitter", "tumblr", "stumbleupon", "flickr", "linkedin", "delicious", "skype", "digg", "vimeo-square", "deviantart", "behance", "instagram", "blogger", "wordpress", "youtube", "reddit", "rss", "soundcloud", "pinterest", "dribbble"];
		foreach ($socials as $social) $instance[$social] = $new_instance[$social];
		return $instance;
	}
	
	function widget($args, $instance) {
			
		extract($args);
		
		echo '<div id="'.$this->id.'" class="widget architek_socials_widget">';
			$title = apply_filters( 'widget_title', empty($instance['title']) ? '' : $instance['title'], $instance );
			if (!empty($title)) { echo wp_kses_post("<h4 class='widget_title_span'>$title</h4><hr>"); }
			echo '<div class="social-icons-fa align-'.esc_attr( $instance['align'] ). '"><ul>';
			$socials = ["facebook", "twitter", "tumblr", "stumbleupon", "flickr", "linkedin", "delicious", "skype", "digg", "vimeo-square", "deviantart", "behance", "instagram", "blogger", "wordpress", "youtube", "reddit", "rss", "soundcloud", "pinterest", "dribbble"];
			$socials_labels = ["Facebook", "Twitter", "Tumblr", "StumbleUpon", "Flickr", "LinkedIn", "Delicious", "Skype", "Digg", "Vimeo", "DeviantArt", "Behance", "Instagram", "Blogger", "WordPress", "Youtube", "Reddit", "RSS", "SoundCloud", "Pinterest", "Dribbble"];
			if ($instance['usePanelOptions'] == "yes"){
				foreach ($socials as $key => $social){
					if (is_string(get_option("architek_icon-".$social)) && get_option("architek_icon-".$social) != "") echo '<li><a href="'.esc_attr(esc_url(get_option("architek_icon-".$social))).'" target="_blank" class="social-network '.$social.'" title="'.esc_attr($socials_labels[$key]).'"><i class="fa fa-'.esc_attr($social).'"></i></a></li>';
				}
			} else {
				foreach ($socials as $key => $social){
					if (isset($instance[$social]) && $instance[$social] != "") echo '<li><a href="'.esc_attr(esc_url( $instance[$social] )).'" target="_blank" class="social-network '.$social.'" title="'.esc_attr($socials_labels[$key]).'"><i class="fa fa-'.esc_attr($social).'"></i></a></li>';
				}
			}
			echo '</ul></div>';
		echo '</div>';
		
		wp_enqueue_style( 'architek-cpt' );
		$widget_style = ' #'.$this->id.' i:before{ font-size: '. intval($instance['iconsize'], 10) .'px !important; color: '. esc_html($instance['color']) .' !important; } #'.$this->id.' i:hover:before{ color: '. esc_html($instance['colorHover']) .' !important; }';
		wp_add_inline_style( 'architek-cpt', $widget_style );
	}
}
register_widget('Architek_Socials_Widget');

?>
