<?php
/**
 * @package WordPress
 * @subpackage Architek
 */
	
	add_action( 'after_setup_theme', 'architek_setup' );
	
	//body class
	function architek_custom_body_class($classes, $class){
		if (get_option('architek_header_style_type') == 'style8' || get_option('architek_header_style_type') == 'style9'){
			if (get_option('architek_fixed_menu') == 'off') $classes[] = "header_not_fixed";
			$classes[] = "content_after_header ".esc_attr(get_option('architek_header_style_type'));
		} 
		else {
			if (is_singular() && get_post_meta(get_the_ID(), 'architek_enable_custom_header_options_value', true)=='yes'){
				if (get_post_meta(get_the_ID(), 'architek_content_to_the_top_value', true) == "off") $classes[] = "content_after_header";
			}
			else {
				if (get_option('architek_content_to_the_top') == "off") $classes[] = "content_after_header";
			}
		}
		return $classes;
	}
	
	add_theme_support( 'wc-product-gallery-zoom' );
	add_theme_support( 'wc-product-gallery-lightbox' );
	add_theme_support( 'wc-product-gallery-slider' );
	
	/* new gutenberg features */
	add_theme_support( 'align-wide' );
	
	add_filter( 'body_class', 'architek_custom_body_class', 10, 2 );
	
	//under construction feature.
	function architek_under_construction(){
		$architek_uc_id = get_option('architek_under_construction_page');
		require_once(get_template_directory().'/template-under-construction.php');
		exit;
	}
	
	
	function architek_setup(){
		//remove notifications
		add_action( 'vc_before_init', 'architek_vcSetAsTheme' );
		function architek_vcSetAsTheme() {
			vc_set_as_theme(true);
			//update_option('wpb_js_gutenberg_disable',1);
		}
		if (function_exists( 'set_revslider_as_theme' )){
			add_action( 'init', 'architek_set_revslider_as_theme' );
			function architek_set_revslider_as_theme() {
				set_revslider_as_theme();
				$rev_opts = get_option('revslider-global-settings');
				if ($rev_opts){
					$rev_opts = json_decode($rev_opts);
					if (is_object($rev_opts)){
						$rev_opts->include = "true";
						update_option('revslider-global-settings', json_encode($rev_opts));
					}
				} else {
					$rev_opts = new stdClass();
					$rev_opts->include = "true";
					update_option('revslider-global-settings', json_encode($rev_opts));
				}
			}
		}
	
		/** 
		 * Add default posts and comments RSS feed links to head
		 */
		add_theme_support( 'automatic-feed-links' );
		
		/* Add theme-supported features. */
		add_theme_support( 'title-tag' );
			
		/**
		 * This theme uses post thumbnails
		 */
		add_theme_support( 'post-thumbnails' );
		
		/**
		 *	This theme supports woocommerce
		 */
		add_theme_support( 'woocommerce' );
			
		/**
		 *	This theme supports editor styles
		 */
		add_editor_style("/css/layout-style.css");
		
		/* Add custom actions. */
		/**
		 * Make theme available for translation
		 * Translations can be filed in the /languages/ directory
		 */
		load_theme_textdomain( 'architek', get_template_directory() . '/languages' );
			
		$locale = get_locale();
		$locale_file = get_template_directory() . "/languages/$locale.php";
		if ( is_readable( $locale_file ) )
			require_once( $locale_file );
		/*
	
		/**
		 * Set the content width based on the theme's design and stylesheet.
		 */
		if ( ! isset( $content_width ) )
			$content_width = 900;
		
		//WMPL
		/**
		 * register panel strings for translation
		 */
		if (function_exists ( 'icl_register_string' )){
			require_once (get_template_directory().'/inc/theme-wpml.php');
		}
		//\WMPL
		
		//declare some global variables that will be used everywhere
		global $architek_new_meta_boxes,
		$architek_new_meta_post_boxes,
		$architek_new_meta_portfolio_boxes,
		$architek_buttons,
		$architek_data;
		$architek_new_meta_boxes=array();
		$architek_new_meta_post_boxes=array();
		$architek_new_meta_portfolio_boxes=array();
		$architek_buttons=array();
		$architek_data=new stdClass();
		
		/*----------------------------------------------------------------
		 *  DEFINE THE MAIN CONSTANTS
		 *---------------------------------------------------------------*/
		//main theme info constants
		
		$my_theme = wp_get_theme();
		define("ARCHITEK_VERSION", $my_theme->Version);
		//define the main paths and URLs
		define("ARCHITEK_LIB_PATH", get_template_directory() . '/lib/');
		define("ARCHITEK_LIB_URL", get_template_directory_uri().'/lib/');
		define("ARCHITEK_JS_PATH", get_template_directory_uri().'/js/');
		define("ARCHITEK_CSS_PATH", get_template_directory_uri().'/css/');
	
		define("ARCHITEK_FUNCTIONS_PATH", ARCHITEK_LIB_PATH . 'functions/');
		define("ARCHITEK_FUNCTIONS_URL", ARCHITEK_LIB_URL.'functions/');
		define("ARCHITEK_CLASSES_PATH", ARCHITEK_LIB_PATH.'classes/');
		define("ARCHITEK_OPTIONS_PATH", ARCHITEK_LIB_PATH.'options/');

		define("ARCHITEK_PLUGINS_PATH", ARCHITEK_LIB_PATH.'plugins/');
		define("ARCHITEK_UTILS_URL", ARCHITEK_LIB_URL.'utils/');
		
		define("ARCHITEK_IMAGES_URL", ARCHITEK_LIB_URL.'images/');
		define("ARCHITEK_CSS_URL", ARCHITEK_LIB_URL.'css/');
		define("ARCHITEK_SCRIPT_URL", ARCHITEK_LIB_URL.'script/');
		define("ARCHITEK_PATTERNS_URL", get_template_directory_uri().'/images/architek_patterns/');
		$uploadsdir=wp_upload_dir();
		define("ARCHITEK_UPLOADS_URL", $uploadsdir['url']);
		define("ARCHITEK_SEPARATOR", '|*|');
		define("ARCHITEK_OPTIONS_PAGE", 'architek_options');
		define("ARCHITEK_STYLE_OPTIONS_PAGE", 'architek_style_options');
		define("ARCHITEK_DEMOS_PAGE", 'architek_demos');
	
		/*----------------------------------------------------------------
		 *  INCLUDE THE FUNCTIONS FILES
		 *---------------------------------------------------------------*/
				
		require_once (ARCHITEK_FUNCTIONS_PATH.'general.php');  //some main common functions
		require_once (ARCHITEK_FUNCTIONS_PATH.'stylesheet.php');  //some main common functions
		add_action('wp_enqueue_scripts', 'architek_style', 1);
		add_action('wp_enqueue_scripts', 'architek_scripts', 10);
		
		require_once (ARCHITEK_FUNCTIONS_PATH.'sidebars.php');  //the sidebar functionality
		if ( isset($_GET['page']) && $_GET['page'] == ARCHITEK_OPTIONS_PAGE ){
			require_once (ARCHITEK_CLASSES_PATH.'upper-options-manager.php');  //the theme options manager functionality
		}
		if ( isset($_GET['page']) && $_GET['page'] == ARCHITEK_STYLE_OPTIONS_PAGE ){
			require_once (ARCHITEK_CLASSES_PATH.'upper-style-options-manager.php');  //the theme options manager functionality
		}
		if ( isset($_GET['page']) && $_GET['page'] == ARCHITEK_DEMOS_PAGE ){
			require_once (ARCHITEK_CLASSES_PATH.'upper-demos-manager.php');  //the theme options manager functionality
		}
			
		require_once (ARCHITEK_CLASSES_PATH.'upper-templater.php');  
		require_once (ARCHITEK_CLASSES_PATH.'upper-custom-data-manager.php');  
		require_once (ARCHITEK_CLASSES_PATH.'upper-custom-page.php');  
		require_once (ARCHITEK_CLASSES_PATH.'upper-custom-page-manager.php');  
		require_once (ARCHITEK_FUNCTIONS_PATH.'custom-pages.php');  //the comments functionality
		require_once (ARCHITEK_FUNCTIONS_PATH.'comments.php');  //the comments functionality
		
		do_action( 'architek_plugin_widgets_init' ); // the architek-plugin-widgets functionality

		require_once (ARCHITEK_FUNCTIONS_PATH.'options.php');  //the theme options functionality
		
		if (is_admin()){
			require_once (ARCHITEK_FUNCTIONS_PATH. 'meta.php');  //adds the custom meta fields to the posts and pages
			add_action('admin_enqueue_scripts','architek_admin_style');
		}
		$functions_path = get_template_directory() . '/functions/';
		
		add_filter('woocommerce_add_to_cart_fragments' , 'architek_woocommerce_header_add_to_cart_fragment' );
		
		add_filter( 'loop_shop_per_page', 'architek_loop_shop_per_page', 20 );

		
		// Declare sidebar widget zone
		if (function_exists('register_sidebar')) {
			register_sidebar(array(
				'name' => esc_html__( 'Blog Sidebar', 'architek' ),
				'id'   => 'sidebar-widgets',
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h2>',
				'after_title'   => '</h2>'
			));
		}
		
		if (!function_exists('architek_wp_pagenavi')){ 
			$including = $functions_path. 'theme-pagenavi.php';
			require_once($including);
		}
		
		/* ------------------------------------------------------------------------ */
		/* Misc
		/* ------------------------------------------------------------------------ */
		// Post Thumbnail Sizes
		if ( function_exists( 'add_image_size' ) ) add_theme_support( 'post-thumbnails' );
		
		if ( function_exists( 'add_image_size' ) ) {
			add_image_size( 'architek_blog', 1000, 563, true );				// Standard Blog Image
			add_image_size( 'architek_mini', 80, 80, true ); 				// used for widget thumbnail
			add_image_size( 'architek_portfolio', 600, 400, true );			// also for blog-medium
			add_image_size( 'architek_regular', 500, 500, true ); 
			add_image_size( 'architek_wide', 1000, 500, true ); 
			add_image_size( 'architek_tall', 500, 1000, true );
			add_image_size( 'architek_widetall', 1000, 1000, true ); 
		}
		
		/* tgm plugin activator */
		/**
		 * Include the TGM_Plugin_Activation class.
		 */
		require_once get_template_directory() . '/lib/functions/class-tgm-plugin-activation.php';
		
		add_action( 'tgmpa_register', 'architek_register_required_plugins' );	
		
		if ( class_exists('VCExtendAddonClass')){
			// Finally initialize code
			new VCExtendAddonClass();
		}
		
		if (get_option("architek_enable_smooth_scroll") == "on"){
			update_option('ultimate_smooth_scroll','enable');
		} else update_option('ultimate_smooth_scroll','disable');
		add_filter( 'woocommerce_enqueue_styles', '__return_false' );
	}
	
	function architek_loop_shop_per_page( $cols ) {
		$cols = get_option( 'posts_per_page', 9 );
		return $cols;
	}
	
	function architek_admin_style(){
		wp_enqueue_style('architek-font-awesome-painel-custom', ARCHITEK_CSS_PATH .'font-awesome-painel-custom.min.css');
		wp_enqueue_script( 'architek-admin', ARCHITEK_JS_PATH .'architek-admin.js', array(), '1',$in_footer = true);
	}
	
	
	
	function architek_wpml_filter_langs( $languages ) {
		foreach ( $languages as $k => $language ) {
			$lang_code = explode ( '-' , $languages[$k]['language_code'] );
			$languages[$k]['native_name']     = ucfirst( $lang_code[0] );
			$languages[$k]['translated_name'] = ucfirst( $lang_code[0] );
		}	
		return $languages;
	}
	add_filter( 'icl_ls_languages', 'architek_wpml_filter_langs' );
	add_filter('wpml_add_language_selector', 'architek_wpml_filter_langs');
	

	/*-----------------------------------------------------------------------------------*/
	/*  THEME REQUIRES
	/*-----------------------------------------------------------------------------------*/
	require_once (get_template_directory().'/inc/theme-styles.php');
	
	function architek_style() {
		$theme = wp_get_theme();
		wp_enqueue_style( 'architek-style', get_template_directory_uri().'/style.css', array(), $theme->Version );
	}
	
	function architek_slug_post_classes( $classes, $class, $post_id ) {
		$architek_is_portfolio = array_search( 'type-portfolio', $classes );
		if ( is_single( $post_id ) && false !== $architek_is_portfolio ) {
			$classes[] = 'container';
		}
		if (is_sticky( $post_id )) $classes[] = 'sticky';	 
		return $classes;
	}
	add_filter( 'post_class', 'architek_slug_post_classes', 10, 3 );
	
	/*-----------------------------------------------------------------------------------*/
	/*  LOAD THEME SCRIPTS
	/*-----------------------------------------------------------------------------------*/
	function architek_scripts(){
	
		if (!is_admin()){
			
			global $vc_addons_url, $wp_query, $post;
			
			if ( is_singular() ) wp_enqueue_script( 'comment-reply' );
			
			wp_enqueue_script( 'architek-upper-modernizr', ARCHITEK_JS_PATH .'utils/upper-modernizr.js', array('jquery'),'1.0',$in_footer = true); /* custom build! */
			wp_enqueue_script( 'waypoint', ARCHITEK_JS_PATH .'utils/waypoint.js', array('jquery'),'1.0',$in_footer = true);
			wp_enqueue_script( 'jquery-stellar', ARCHITEK_JS_PATH .'utils/jquery.stellar.min.js', array('jquery'),'1.0',$in_footer = true);
			wp_enqueue_script( 'jquery-flexslider', ARCHITEK_JS_PATH .'utils/jquery.flexslider-min.js', array('jquery'),'1.0',$in_footer = true);
			wp_enqueue_script( 'architek-upper-isotope', ARCHITEK_JS_PATH .'utils/upper-isotope.js', array('jquery'),'1.0',$in_footer = true); /* custom build! */
			wp_enqueue_script( 'queryLoader2', ARCHITEK_JS_PATH .'utils/queryLoader.js', array('jquery'),'1.0',$in_footer = true);
			wp_enqueue_script( 'bootstrap', ARCHITEK_JS_PATH .'utils/bootstrap.min.js', array('jquery'),'1.0',$in_footer = true);
			wp_enqueue_script( 'jquery-dlmenu', ARCHITEK_JS_PATH .'utils/jquery.dlmenu.js', array('jquery'),'1.0',$in_footer = true);
			wp_enqueue_script( 'jquery-select2', ARCHITEK_JS_PATH .'utils/jquery.select2.js', array('jquery'),'1.0',$in_footer = true);
			
			  wp_enqueue_script( 'jquery-effects-core', array('jquery') );
			  
			  if (get_option('architek_header_after_scroll_type2') == 'on') wp_enqueue_script( 'imagesloaded', array('jquery') );
			  
			wp_register_script( 'architek-global', ARCHITEK_JS_PATH .'global.js', array('jquery'), '1',$in_footer = true);
			
			if (is_archive() || is_single() || is_search() || is_page_template('blog-template.php') || is_page_template('blog-masonry-template.php') || is_page_template('blog-masonry-grid-template.php') || is_home()) {

				$nposts = get_option('posts_per_page'); $architek_more = 0; $architek_pag = 0; $max = 0; $orderby=""; $category=""; $nposts = ""; $order = "";
				$architek_pag = $wp_query->query_vars['paged'];
				if (!is_numeric($architek_pag)) $architek_pag = 1;
				
				$architek_reading_option = get_option('architek_blog_reading_type');
				
				switch ($architek_reading_option){
					case "scrollauto": 
							// Add code to index pages.
							if( !is_singular() ) {	
								if (is_search()){
									$se = get_option("architek_enable_search_everything");
									$nposts = get_option('posts_per_page');
									$architek_pag = $wp_query->query_vars['paged'];
									if (!is_numeric($architek_pag)) $architek_pag = 1;

									if ($se == "on"){
										$args = array( 'showposts' => get_option('posts_per_page'), 'post_status' => 'publish', 'paged' => $architek_pag, 's' => esc_html($_GET['s']));
										$architek_the_query = new WP_Query( $args );
										$args2 = array( 'showposts' => -1, 'post_status' => 'publish', 'paged' => $architek_pag, 's' => esc_html($_GET['s']) );
										$counter = new WP_Query($args2);
									} else {
										$args = array('showposts' => get_option('posts_per_page'),'post_status' => 'publish','paged' => $architek_pag,'post_type' => 'post','s' => esc_html($_GET['s']));
										$architek_the_query = new WP_Query( $args );
										$args2 = array('showposts' => -1,'post_status' => 'publish','paged' => $architek_pag,'post_type' => 'post','s' => esc_html($_GET['s']));
										$counter = new WP_Query($args2);
									}
									$max = ceil($counter->post_count / $nposts);
									$architek_paged = ( get_query_var('paged') > 1 ) ? get_query_var('paged') : 1;
								} else {
									$max = $wp_query->max_num_pages;
									$architek_paged = ( get_query_var('paged') > 1 ) ? get_query_var('paged') : 1;
								}
								$architek_inline_script = '
									jQuery(document).ready(function($){
										"use strict";
										if (window.architekOptions.reading_option === "scrollauto" && !jQuery("body").hasClass("single") && typeof architek_monitorScrollTop == "function"){ 
											window.architek_loadingPoint = 0;
											//monitor page scroll to fire up more posts loader
											window.clearInterval(window.architek_interval);
											window.architek_interval = setInterval("architek_monitorScrollTop()", 1000 );
										}
									});
								';
								wp_add_inline_script('architek-global', $architek_inline_script, 'after');
							} else {
								$args = array('showposts' => $nposts,'orderby' => $orderby,'order' => $order,'cat' => $category,'paged' => $architek_pag,'post_status' => 'publish');
								$architek_the_query = new WP_Query( $args );
								$max = $architek_the_query->max_num_pages;
								$architek_paged = ( get_query_var('paged') > 1 ) ? get_query_var('paged') : 1;
								$architek_inline_script = '
									jQuery(document).ready(function($){
										"use strict";
										if (window.architekOptions.reading_option === "scrollauto" && !jQuery("body").hasClass("single") && typeof architek_monitorScrollTop == "function"){ 
											window.architek_loadingPoint = 0;
											//monitor page scroll to fire up more posts loader
											window.clearInterval(window.architek_interval);
											window.architek_interval = setInterval("architek_monitorScrollTop()", 1000 );
										}
									});
								';
								wp_add_inline_script('architek-global', $architek_inline_script, 'after');

							}
						break;
					case "scroll": 
							if( !is_singular() ) {	
								if (is_search()){
									$nposts = get_option('posts_per_page');
									$se = get_option("architek_enable_search_everything");
									if ($se == "on"){
										$args = array('showposts' => get_option('posts_per_page'),'post_status' => 'publish','paged' => $architek_pag,'s' => esc_html($_GET['s']));
										$architek_the_query = new WP_Query( $args );
										$args2 = array('showposts' => -1,'post_status' => 'publish','paged' => $architek_pag,'s' => esc_html($_GET['s']));
										$counter = new WP_Query($args2);
									} else {
										$args = array('showposts' => get_option('posts_per_page'),'post_status' => 'publish','paged' => $architek_pag,'post_type' => 'post','s' => esc_html($_GET['s']));
										$architek_the_query = new WP_Query( $args );
										$args2 = array('showposts' => -1,'post_status' => 'publish','paged' => $architek_pag,'post_type' => 'post','s' => esc_html($_GET['s']));
										$counter = new WP_Query($args2);
									}
									$max = ceil($counter->post_count / $nposts);
									$architek_pag = 1;
									$architek_pag = $wp_query->query_vars['paged'];
									if (!is_numeric($architek_pag)) $architek_pag = 1;
								} else {
									$max = $wp_query->max_num_pages;
									$architek_paged = $architek_pag;
								}
							} else {
								$orderby = ""; $category = "";
								$args = array('showposts' => $nposts,'orderby' => $orderby,'order' => $order,'cat' => $category,'post_status' => 'publish');
								$architek_the_query = new WP_Query( $args );
								$max = $architek_the_query->max_num_pages;
								$architek_pag = 1;
								$architek_pag = $wp_query->query_vars['paged'];
								if (!is_numeric($architek_pag)) $architek_pag = 1;
							}
						break;
				}
			} 
			
			/* pass needed options values to JS */
			$architekOptions = array(
				"templatepath" => esc_url(get_template_directory_uri())."/",
				"homePATH" => ABSPATH,
				"styleColor" => "#".esc_html(get_option("architek_style_color")),
				"architek_no_more_posts_text" => function_exists('icl_t') ? sprintf(esc_html__("%s", "architek"), icl_t( 'architek', 'No more posts to load.', get_option('architek_no_more_posts_text'))) : sprintf(esc_html__("%s", "architek"), get_option('architek_no_more_posts_text')),
				"architek_load_more_posts_text" => function_exists('icl_t') ? sprintf(esc_html__("%s", "architek"), icl_t( 'architek', 'Load More Posts', get_option('architek_load_more_posts_text'))) : sprintf(esc_html__("%s", "architek"), get_option('architek_load_more_posts_text')),
				"architek_loading_posts_text" => function_exists('icl_t') ? sprintf(esc_html__("%s", "architek"), icl_t( 'architek', 'Loading posts.', get_option('architek_loading_posts_text'))) : sprintf(esc_html__("%s", "architek"), get_option('architek_loading_posts_text')),
				
				"architek_back_menu" => function_exists('icl_t') ? sprintf(esc_html__("%s", "architek"), icl_t( 'architek', 'Back', get_option('architek_back_menu'))) : sprintf(esc_html__("%s", "architek"), get_option('architek_back_menu')),
				
				
				"searcheverything" => get_option("architek_enable_search_everything"),
				"architek_header_shrink" => get_option('architek_fixed_menu') == 'on' && get_option('architek_header_after_scroll') == 'on' && get_option('architek_header_shrink_effect') == 'on' ? 'yes' : 'no',
				"architek_header_after_scroll" => get_option('architek_fixed_menu') == 'on' && get_option('architek_header_after_scroll') == 'on' ? 'yes' : 'no',
				
				"architek_header_after_scroll_type2" => get_option('architek_header_after_scroll_type2') == 'on' && (get_option('architek_header_style_type') != 'style8' && get_option('architek_header_style_type') != 'style9') ? 'yes' : 'no',
				
				"architek__portfolio_grayscale_effect" => get_option("architek_enable_portfolio_grayscale"),
				"architek__instagram_grayscale_effect" => get_option("architek_enable_instagram_grayscale"),
				"architek_enable_ajax_search" => get_option("architek_enable_ajax_search"),
				"architek_newsletter_input_text" => function_exists('icl_t') ? esc_html(icl_t( 'architek', 'Enter your email here', get_option('architek_newsletter_input_text'))) : esc_html(get_option('architek_newsletter_input_text')),
				"architek_update_section_titles" => get_option('architek_update_section_titles'),
				"architek_wpml_current_lang" => function_exists('icl_t') ? ICL_LANGUAGE_CODE : "",
				"reading_option" => isset($architek_reading_option) ? $architek_reading_option : "paged", 
				"loader_startPage" => isset($architek_pag) ? $architek_pag : 0,
				"loader_maxPages" => isset($max) ? $max : 0,
				
				"architek_grayscale_effect" => get_option("architek_enable_grayscale")
			);
			
			wp_localize_script( 'architek-global', 'architekOptions', $architekOptions );
			wp_enqueue_script( 'architek-global' );

			add_action( 'wp_footer', 'architek_set_import_fonts' );
		   
			  wp_enqueue_script('cubeportfolio-jquery-js',$in_footer = false);
			wp_enqueue_style('cubeportfolio-jquery-css',$in_footer = false);
			

			if (is_single()){
				wp_enqueue_script( 'lightbox2' ); wp_enqueue_style( 'lightbox2' );
				wp_enqueue_style( 'prettyphoto'); wp_enqueue_script( 'prettyphoto'); 
			}
			if (isset($post->ID)) $template = get_post_meta( $post->ID, '_wp_page_template' ,true );
						
			if (isset($template) && ( $template == 'template-blank.php' || $template == 'one-page-template.php' || $template == 'template-home.php') || is_404()){
				if (class_exists('Ultimate_VC_Addons')) {
					wp_enqueue_style('ultimate-vc-addons-style-min');
					wp_enqueue_script('ultimate-vc-addons-script');
					wp_enqueue_script('ultimate-vc-addons-params');
					wp_enqueue_script('ultimate-vc-addons-googleapis');
			
				}
			}
			
			/* Fix map on onepage */
			if (isset($template) && ( $template == 'template-home.php')){
				if (class_exists('Ultimate_VC_Addons')) {
					wp_enqueue_script('ultimate-vc-addons-googleapis');
			
				}
			}
			
				
			if ((isset($template) && ($template == 'blog-masonry-template.php' || $template == 'blog-template.php' || $template == 'blog-masonry-grid-template.php'|| $template == 'blog-template.php')) || is_archive() || is_search() || is_home()){
				wp_enqueue_script( 'architek-blog', ARCHITEK_JS_PATH .'blog.js', array('jquery'), '1',$in_footer = true);
			}
			
			wp_dequeue_style( 'wp-mediaelement' );
			wp_dequeue_script( 'wp-mediaelement' ); 
			
		}
	}


	/*-----------------------------------------------------------------------------------*/
	/*  FUNCTION FOR INSTALL AND REGISTER THEME PLUGINS
	/*-----------------------------------------------------------------------------------*/
	function architek_register_required_plugins() {
	
		$plugins = array(
			array(
				'name'      => 'Contact Form 7',
				'slug'      => 'contact-form-7',
				'required'  => true,
			),
			array(
				'name'      => 'Widget Importer & Exporter',
				'slug'      => 'widget-importer-exporter',
				'required'  => false,
			),
			
			array(
				'name'      => 'Classic Widgets',
				'slug'      => 'classic-widgets',
				'required'  => false,
			),
			array(
				'name'      => 'Classic Editor',
				'slug'      => 'classic-editor',
				'required'  => false,
			),
			
			array(
				'name'          => 'WPBakery Visual Composer',
				'slug'          => 'js_composer',
				'source'        => 'https://boldway.agency/plugins/architek/js_composer.zip',
				'required'      => true,
				'version'       => '15.0.1'
			),
			array(
				'name'      	=> 'Revolution Slider',
				'slug'     	 	=> 'revslider',
				'source'        => 'https://boldway.agency/plugins/architek/revslider.zip',
				'required'  	=> true,
				'version'       => '6.7.38'
			),
			
			array(
				'name'          => 'Ultimate Addons for Visual Composer',
				'slug'          => 'Ultimate_VC_Addons',
				'source'        => 'https://boldway.agency/plugins/architek/Ultimate_VC_Addons.zip',
				'required'      => true,
				'version'       => '15.0'
			),
			
			array(
				'name'      	=> 'Architek Custom Post Types',
				'slug'     	 	=> 'architek_custom_post_types',
				'source'        => 'https://boldway.agency/plugins/architek/architek_custom_post_types.zip',
				'required'  	=> true,
				'version'       => '1.4'
			),
			array(
				'name'      	=> 'Envato Market',
				'slug'     	 	=> 'envato-market',
				'source'        => 'https://boldway.agency/plugins/architek/envato-market.zip',
				'required'  	=> true,
				'version'       => '2.0.12'
			),
			
			array(
				'name'          => 'Cube Portfolio',
				'slug'          => 'cubeportfolio',
				'source'        => 'https://boldway.agency/plugins/architek/cubeportfolio.zip',
				'required'      => true,
				'version'       => '5.0'
			)
		);
	
		// Change this to your theme text domain, used for internationalising strings
		$config = array(
			'domain'       		=> 'architek',         	// Text domain - likely want to be the same as your theme.
			'default_path' 		=> '',
			'parent_slug'  => 'themes.php',            			// Parent menu slug.
			'menu'         		=> 'install-required-plugins', 	// Menu slug
			'has_notices'      	=> true,                       	// Show admin notices or not
			'is_automatic'    	=> false,					   	// Automatically activate plugins after installation or not
			'message' 			=> '',							// Message to output right before the plugins table
			'strings'      		=> array(
				'page_title'                       			=> esc_html__( 'Install Required Plugins', 'architek' ),
				'menu_title'                       			=> esc_html__( 'Install Plugins', 'architek' ),
				'installing'                       			=> esc_html__( 'Installing Plugin: %s', 'architek' ), // %1$s = plugin name
				'oops'                             			=> esc_html__( 'Something went wrong with the plugin API.', 'architek' ),
				'notice_can_install_required'     			=> _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.', 'architek' ), // %1$s = plugin name(s)
			'notice_can_install_recommended'			=> _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.', 'architek' ), // %1$s = plugin name(s)
			'notice_cannot_install'  					=> _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'architek' ), // %1$s = plugin name(s)
			'notice_can_activate_required'    			=> _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.', 'architek' ), // %1$s = plugin name(s)
			'notice_can_activate_recommended'			=> _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', 'architek' ), // %1$s = plugin name(s)
			'notice_cannot_activate' 					=> _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'architek' ), // %1$s = plugin name(s)
			'notice_ask_to_update' 						=> _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 'architek' ), // %1$s = plugin name(s)
			'notice_cannot_update' 						=> _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'architek' ), // %1$s = plugin name(s)
				'install_link' 					  			=> _n_noop( 'Begin installing plugin', 'Begin installing plugins', 'architek' ),
				'activate_link' 				  			=> _n_noop( 'Activate installed plugin', 'Activate installed plugins', 'architek' ),
				'return'                           			=> esc_html__( 'Return to Required Plugins Installer', 'architek' ),
				'plugin_activated'                 			=> esc_html__( 'Plugin activated successfully.', 'architek' ),
				'complete' 									=> esc_html__( 'All plugins installed and activated successfully. %s', 'architek' ), // %1$s = dashboard link
				'nag_type'									=> 'updated' // Determines admin notice type - can only be 'updated' or 'error'
			)
		);
	
		tgmpa( $plugins, $config );
	
	}
	

	
	/*-----------------------------------------------------------------------------------*/
	/*  THEME REQUIRES
	/*-----------------------------------------------------------------------------------*/
	 if (file_exists(get_stylesheet_directory().'/inc/theme-intro.php')) require_once (get_stylesheet_directory().'/inc/theme-intro.php');
	 else require_once (get_template_directory().'/inc/theme-intro.php');
	 
	 if (file_exists(get_stylesheet_directory().'/inc/theme-header.php')) require_once (get_stylesheet_directory().'/inc/theme-header.php');
	 else require_once (get_template_directory().'/inc/theme-header.php');
	 
	 if (file_exists(get_stylesheet_directory().'/inc/theme-walker-menu.php')) require_once (get_stylesheet_directory().'/inc/theme-walker-menu.php');
	 else require_once (get_template_directory().'/inc/theme-walker-menu.php');
	 
	 if (file_exists(get_stylesheet_directory().'/inc/theme-homeslider.php')) require_once (get_stylesheet_directory().'/inc/theme-homeslider.php');
	 else require_once (get_template_directory().'/inc/theme-homeslider.php');
	 
	 if (file_exists(get_stylesheet_directory().'/inc/theme-breadcrumb.php')) require_once (get_stylesheet_directory().'/inc/theme-breadcrumb.php');
	 else require_once (get_template_directory().'/inc/theme-breadcrumb.php');
	 
	 if (file_exists(get_stylesheet_directory().'/inc/theme-menu.php')) require_once (get_stylesheet_directory().'/inc/theme-menu.php');
	 else require_once (get_template_directory().'/inc/theme-menu.php');
	 
	 if (file_exists(get_stylesheet_directory().'/inc/theme-woocart.php')) require_once (get_stylesheet_directory().'/inc/theme-woocart.php');
	 else require_once (get_template_directory().'/inc/theme-woocart.php');
	 
	
	/*-----------------------------------------------------------------------------------*/
	/*  FUNCTION FOR ONE CLICK FEATURE
	/*-----------------------------------------------------------------------------------*/
	function architek_autoimport($url, $demo) {
		
		$os = ((strpos(strtolower(PHP_OS), 'win') === 0) || (strpos(strtolower(PHP_OS), 'cygwin') !== false)) ? 'win' : 'other';
		if (!function_exists('WP_Filesystem')){
			$abspath = ($os === "win") ? "\wp-admin\includes\file.php" : "/wp-admin/includes/file.php";
			require_once(ABSPATH.$abspath);
		}
		WP_Filesystem();
		global $wpdb, $wp_filesystem;
		
		// get the file
		require_once get_template_directory() . '/lib/classes/upper-content-import.php';
	
		if ( ! class_exists( 'architek_Auto_Importer' ) )
			die( 'architek_Auto_Importer not found' );
	
		// call the function
		$upload_dir = wp_upload_dir();
		$demo_file = $url.$demo."/contents.xml";
		$tempfile = $upload_dir['basedir'] . '/temp.xml' ;
		$data = $wp_filesystem->get_contents($demo_file);
		if (!$data) $data = wp_remote_fopen($demo_file);
		$result = $wp_filesystem->put_contents($tempfile, $data, FS_CHMOD_FILE);
		
		if ($result){
			$args = array(
				'file'        => $tempfile,
				'map_user_id' => 0
			);
			architek_auto_import( $args );
		}
	
	}


	/*-----------------------------------------------------------------------------------*/
	/*  HEX TO RGB
	/*-----------------------------------------------------------------------------------*/
	function architek_hex2rgb($hex = "000000") {
		if (is_array($hex)) $hex = "000000";
		$hex = str_replace("#", "", $hex);
		
		if(strlen($hex) == 3) {
			$r = hexdec(substr($hex,0,1).substr($hex,0,1));
			$g = hexdec(substr($hex,1,1).substr($hex,1,1));
			$b = hexdec(substr($hex,2,1).substr($hex,2,1));
		} else {
			$r = hexdec(substr($hex,0,2));
			$g = hexdec(substr($hex,2,2));
			$b = hexdec(substr($hex,4,2));
		}
		$rgb = array($r, $g, $b);
		return $rgb; // returns an array with the rgb values
	}



	function architek_get_string_between($string, $start, $end){
		$string = " ".$string;
		$ini = strpos($string,$start);
		if ($ini == 0) return "";
		$ini += strlen($start);
		$len = strpos($string,$end,$ini) - $ini;
		return substr($string,$ini,$len);
	}
	
	/* Remove VC Modules */
	if (function_exists('vc_remove_element')){
		vc_remove_element('vc_carousel');
		vc_remove_element('vc_posts_slider');
		vc_remove_element('vc_gallery');
		vc_remove_element('vc_images_carousel');
		vc_remove_element('vc_button');
		vc_remove_element('vc_cta_button');
		vc_remove_element('vc_wp_search');
		vc_remove_element('vc_wp_meta');
		vc_remove_element('vc_wp_recentcomments');
		vc_remove_element('vc_wp_calendar');
		vc_remove_element('vc_wp_pages');
		vc_remove_element('vc_wp_tagcloud');	
		vc_remove_element('vc_wp_custommenu');
		vc_remove_element('vc_wp_text');
		vc_remove_element('vc_wp_posts');
		vc_remove_element('vc_wp_categories');
		vc_remove_element('vc_wp_archives');
		vc_remove_element('vc_wp_rss');
		vc_remove_element('vc_message');
		vc_remove_element('vc_gmaps');
		vc_remove_element('vc_flickr');
	}
	
	
	/*-----------------------------------------------------------------------------------*/
	/*  INCLUDE ADDONS IN ARCHITEK THEME
	/*-----------------------------------------------------------------------------------*/
	function architek_content_shortcoder($post_content, $loadglobally = false){
		
		$dependancy = array('jquery');
		global $vc_addons_url, $is_IE;

			
		if (isset($vc_addons_url) && $vc_addons_url != ""){
			
			$js_path = 'assets/min-js/';
			$css_path = 'assets/min-css/';
			$ext = '.min';
			$isAjax = true;
			$ultimate_smooth_scroll = get_option('ultimate_smooth_scroll');
	
			// register js
			if($ultimate_smooth_scroll === 'enable') {
				$smoothScroll = 'SmoothScroll-compatible.min.js';
			}
			else {
				$smoothScroll = 'SmoothScroll.min.js';
			}
			if (!$is_IE) wp_register_script('ultimate-vc-addons-smooth-scroll',$vc_addons_url.'assets/min-js/'.$smoothScroll,array('jquery'),'15.0',true);

			// register css
			wp_register_style('ultimate-vc-addons-animate',$vc_addons_url.$css_path.'animate'.$ext.'.css',array(),'15.0');
			wp_register_style('ultimate-vc-addons-style',$vc_addons_url.$css_path.'style'.$ext.'.css',array(),'15.0');
	
			$ultimate_smooth_scroll = get_option('ultimate_smooth_scroll');
			if($ultimate_smooth_scroll == "enable" || $ultimate_smooth_scroll === 'enable') {
				wp_enqueue_script('ultimate-vc-addons-smooth-scroll');
			}
	
			if(function_exists('vc_is_frontend_editor')){
				if(vc_is_frontend_editor()){
					wp_enqueue_style('vc-fronteditor',$vc_addons_url.'assets/min-css/vc-fronteditor.min.css');
				}
			}
	
			$ultimate_global_scripts = ($loadglobally) ? 'enable' : bsf_get_option('ultimate_global_scripts');

			if($ultimate_global_scripts === 'enable') {
				
				if ( defined( 'DISABLE_ULTIMATE_GOOGLE_MAP_API' ) && ( true == DISABLE_ULTIMATE_GOOGLE_MAP_API || 'true' == DISABLE_ULTIMATE_GOOGLE_MAP_API ) ) {
					$load_map_api = false;
				} else {
					$load_map_api = true;
				}
				if ( $load_map_api ) {
					wp_enqueue_script( 'ultimate-vc-addons-googleapis' );
				}
				
				$ultimate_google_font_manager = new Ultimate_VC_Addons_Google_Font_Manager();
				$ultimate_google_font_manager->enqueue_selected_ultimate_google_fonts();
				
				return false;
			}
	
			if(!is_404() && !is_search()){
	
				if(stripos($post_content, 'font_call:'))
				{
					preg_match_all('/font_call:(.*?)"/',$post_content, $display);
					if (function_exists('enquque_ultimate_google_fonts_optimzed')) enquque_ultimate_google_fonts_optimzed($display[1]);
				}
				
				if( stripos( $post_content, '[swatch_container') || 
					stripos( $post_content, '[ultimate_modal'))
				{
					wp_enqueue_script('ultimate-vc-addons-modernizr');
				}

				if( stripos( $post_content, '[icon_timeline') ) {
					wp_enqueue_script('masonry');
				}

				if($isAjax == true) { // if ajax site load all js
					wp_enqueue_script('masonry');
				}

				if( stripos( $post_content, '[ultimate_google_map') ) {
					if(defined('DISABLE_ULTIMATE_GOOGLE_MAP_API') && (DISABLE_ULTIMATE_GOOGLE_MAP_API == true || DISABLE_ULTIMATE_GOOGLE_MAP_API == 'true'))
						$load_map_api = false;
					else
						$load_map_api = true;
					if($load_map_api)
						wp_enqueue_script('ultimate-vc-addons-googleapis');
				}

				if( stripos( $post_content, '[ult_range_slider') ) {
					wp_enqueue_script('jquery-ui-mouse');
					wp_enqueue_script('jquery-ui-widget');
					wp_enqueue_script('jquery-ui-slider');
					wp_enqueue_script('ultimate-vc-addons_range_tick');
					wp_enqueue_script('ultimate-vc-addons_ui_touch_punch');
				}

				wp_enqueue_script('ultimate');

				if( stripos( $post_content, '[ultimate_modal') ) {
					wp_enqueue_script('ultimate-vc-addons-modal-all');
				}
				
				$ultimate_css = "enable";
	
				if ($ultimate_css == "enable"){
					wp_enqueue_style('ultimate-vc-addons-style-min');
					if( stripos( $post_content, '[ultimate_carousel') ) {
						wp_enqueue_style("ultimate-vc-addons-icons");
					}
				} 
				
				wp_enqueue_script( 'ultimate-vc-addons-row-bg', $vc_addons_url.$js_path . 'ultimate_bg' . $ext . '.js' );
			}
		}
	}	

	/*-----------------------------------------------------------------------------------*/
	/*  REQUIRED FOR WOOCOMMERCE CART
	/*-----------------------------------------------------------------------------------*/
	require_once (get_template_directory().'/inc/theme-woocart.php');
	
	
	function architek_allowed_tags() {
		global $allowedtags, $allowedposttags;
		$allowedtags['option'] = array('style'=>array(), 'id'=>array(), 'name'=>array(), 'class'=>array(), 'value'=>array(), 'selected'=>array());
		$allowedtags['input'] = array('style'=>array(), 'id'=>array(), 'name'=>array(), 'class'=>array(), 'value'=>array(), 'selected'=>array(), 'type'=>array(), 'onchange'=>array(), 'placeholder'=>array());
		$allowedtags['label'] = array('for'=>array());
		$allowedtags['iframe'] = array('style'=>array(), 'src'=>array(), 'allowfullscreen'=>array());
		$allowedposttags['div']['aria-hidden'] = array();
		$allowedposttags['div']['style'] = array();
		$allowedtags = array_merge($allowedtags, $allowedposttags);
	}
	add_action('init', 'architek_allowed_tags', 10);

	function architek_get_the_woo(){
		global $woocommerce;
		return isset($woocommerce) ? $woocommerce : array(); 
	}

	/*-----------------------------------------------------------------------------------*/
	/*  LOAD GOOGLE FONTS
	/*-----------------------------------------------------------------------------------*/
	function architek_fonts_url() {
		
		global $architek_import_fonts;
		
		$architek_import_fonts = architek_get_import_fonts();
		if (!is_array($architek_import_fonts) && is_string($architek_import_fonts)) $architek_import_fonts = explode("|",$architek_import_fonts);
		
		$aux = array();
		foreach ($architek_import_fonts as $font){
			$aux[] = str_replace("|", ":", str_replace(" ", "+", $font));
		}
		
		$aux = array_unique($aux);
		
		$http = (is_ssl( )) ? "https:" : "http:";
		
		$keys = array("Arial","Arial+Black","Helvetica+Neue","Helvetica","Courier+New","Georgia","Impact","Lucida+Sans","Times+New+Roman","Trebuchet+MS","Verdana");
		
		foreach ($keys as $key){
			if (($key_search = array_search($key, $aux)) !== false) {
				unset($aux[$key_search]);
			}
		}
		
		$architek_import_fonts = implode("|", $aux);
		$font_url = '';

		// New option to disable theme google fonts
		if (get_option('architek_display_googlefonts')=="on"){
			if ( 'off' !== _x( 'on', 'Google font: on or off', 'architek' ) ) {
				$font_url = add_query_arg( 'family', $architek_import_fonts, $http."//fonts.googleapis.com/css", array(), null, 'all' );
			}
			return $font_url;
		}
		
	}
	
	function architek_google_fonts_scripts() {
		wp_enqueue_style( 'architek-google-fonts', architek_fonts_url(), '' );
	}
	
	function architek_get_custom_inline_css(){
		global $architek_inline_css;
		wp_enqueue_style('architek-custom-style', ARCHITEK_CSS_PATH .'architek-custom.css',99);
		if (!$architek_inline_css) $architek_inline_css = "";
		$architek_inline_css .= "body{visibility:visible;}";
		wp_add_inline_style('architek-custom-style', $architek_inline_css);
	}
	
	function architek_set_custom_inline_css($css){
		global $architek_inline_css;
		$upper_theme_main_color = "#".get_option('architek_style_color');
		$architek_inline_css .= str_replace( '__USE_THEME_MAIN_COLOR__', $upper_theme_main_color, $css );
	}
	
	function architek_set_team_profiles_content($content){
		global $architek_team_profiles;
		if (!isset($architek_team_profiles)) $architek_team_profiles = '';
		$architek_team_profiles .= $content;
	}
	
	function architek_get_team_profiles_content(){
		global $architek_team_profiles;
		if (isset($architek_team_profiles)){
			$architek_team_profiles = wp_kses_no_null( $architek_team_profiles, array( 'slash_zero' => 'keep' ) );
			$architek_team_profiles = wp_kses_normalize_entities($architek_team_profiles);
			echo wp_kses_hook($architek_team_profiles, 'post', array());
		}
	}
	
	if (!function_exists('upper_images_only')){
		function upper_images_only( $media_item ) {
			if ( $media_item['type'] == 'image' )
				return true;
			return false;
		}
	}
	
	// ajax workers
	//front
	if (get_option('architek_enable_search')=="on" && get_option('architek_enable_ajax_search')=="on"){
		include_once get_template_directory() . '/ajaxsearch.php';
	}

	//back
	if ( is_admin() && current_user_can( 'manage_options' ) ) {
		require_once get_template_directory() . '/lib/script/loadSettings.php';
		require_once get_template_directory() . '/lib/functions/architek_demo_installer.php';
		require_once get_template_directory() . '/lib/utils/upload-handler.php';
		require_once get_template_directory() . '/lib/functions/queryprojectsforcube.php';
		$architek_imported_ids = get_option('architek_imported_ids');
		if (!$architek_imported_ids){
			$architek_imported_ids = array();
			update_option('architek_imported_ids', $architek_imported_ids);
		}
		$architek_imported_ids;
	}
	
	if (!function_exists('architek_get_imported_ids')){
		function architek_get_imported_ids(){
			global $architek_imported_ids;
			return $architek_imported_ids;
		}
	}
	
	if (!function_exists('architek_set_imported_ids')){
		function architek_set_imported_ids($ids){
			global $architek_imported_ids;
			$architek_imported_ids = $ids;
			update_option('architek_imported_ids', $architek_imported_ids);
		}
	}
	
	if (!function_exists('architek_add_imported_id')){
		function architek_add_imported_id( $id, $revs = false ){
			$aux = get_option('architek_imported_ids');
			$output = "";
			if ($revs){
				if ( !array_search( $id, $aux ) ){
					array_push( $aux, $id );
					architek_set_imported_ids($aux);
					return true;
				} else {
					return false;
				}
			} else {
				if ( !array_search( intval($id), $aux ) ){
					array_push( $aux, (int)$id );
					architek_set_imported_ids($aux);
					return true;
				} else {
					return false;
				}
			}
		}
	}