<?php
/**
 * @package WordPress
 * @subpackage Architek
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<meta content="width=device-width, initial-scale=1.0, maximum-scale=1" name="viewport">
	<?php wp_head(); ?>
</head>

<?php
	if (get_option('architek_enable_under_construction') === "on" && get_option('architek_under_construction_page') != "0" && !is_user_logged_in()){
		add_action('template_redirect', architek_under_construction());
	}
?>

<body <?php body_class(); if (get_option("architek_body_type") == "body_boxed" && get_option('architek_header_style_type')!='style9') echo esc_attr(' id=boxed_layout');?>>
	<?php if (function_exists('wp_body_open')) wp_body_open(); ?>
	<?php
		if (get_option("architek_sliding_panel") == "on" && !is_page_template( 'template-under-construction.php') && 
			(function_exists('dynamic_sidebar') && is_active_sidebar( 'sliding_panel_sidebar' )) && get_option('architek_header_style_type')!='style9'){
			?>
			<div class="architek-push-sidebar architek-push-sidebar-right">
			    <?php
				if (get_option("architek_sliding_panel") == "on" && (function_exists('dynamic_sidebar') && is_active_sidebar( 'sliding_panel_sidebar' ))){
					?>					
						<div class="menu-controls sliderbar-menu-controller" title="Sidebar Menu Controller">
                            <div class="font-icon custom-font-icon">
	                            <span class="hamburguer-trigger-menu-icon">   
									<span class="hamburguer-line hamburger-line-1"></span>
									<span class="hamburguer-line hamburger-line-2"></span>
									<span class="hamburguer-line hamburger-line-3"></span>
								</span>
                            </div>
                        </div>
					<?php
				}
				
			?>
			    <div class="display-table">
			        <div id="architek-push-sidebar-content" class="architek-push-sidebar-content ajaxable">
				        <?php
					        if (function_exists('dynamic_sidebar') && is_active_sidebar( 'sliding_panel_sidebar' )){
						        dynamic_sidebar('sliding_panel_sidebar');
					        }
				        ?>
			        </div>
			    </div>
			</div>
			<?php
		}

		//the search input
		if (get_option("architek_enable_search") == "on"){
			if ( function_exists('wp_nonce_field') ){
				wp_nonce_field('architek-theme-search','architek-theme-search');
			}
			?>
			<form autocomplete="off" role="search" method="get" class="search_input architek_search_input not-ready <?php echo esc_attr(get_option("architek_search_open_effect","fade")); ?> <?php echo esc_attr(get_option("architek_header_style_type")); if (get_option("architek_header_full_width")=="on") echo " full-width-header"; ?> <?php if (get_option("architek_search_input_enable_underline","on") == "on") echo esc_attr( "with-underline" ); ?> <?php if (get_option("architek_search_input_enable_animations","on") == "on") echo esc_attr( "with-animations" ); ?>" action="<?php echo esc_url(home_url("/")); ?>">
				<div class="search_close">
					<div class="icon dripicons-cross"></div>
				</div>
				<div class="form_bearer container">
					<div class="searchinput <?php if (get_option("architek_header_full_width") == "off") echo "container"; ?>">
						<input value="" name="s" class="search_input_value" type="text" placeholder="<?php
							if (function_exists('icl_t')){
								printf(esc_html__("%s","architek"), icl_t( 'architek', 'Type your search and hit enter...', get_option('architek_search_box_text')));
							} else {
								printf(esc_html__("%s","architek"), get_option("architek_search_box_text"));
							}
						?>" />
						<input class="hidden" type="submit" id="searchsubmit" value="Search" />
						<div class="ajax_search_results"><ul></ul></div>
					</div>
				</div>
				<?php
					if (function_exists('icl_t')){
						?>
						<input class="hidden" name="lang" type="text" value="<?php echo ICL_LANGUAGE_CODE; ?>" />
						<?php
					}
				?>
			</form>	
			<?php
		}
	?>
	
	


	<div id="main">

		<?php
			if (get_option('architek_layout_grid_lines_enable', 'off') == 'on'){
				?>
				<div class="body-lines"><div class="body-line"></div><div class="body-line"></div><div class="body-line"></div><div class="body-line"></div><div class="body-line"></div><div class="body-line"></div></div>
				<?php
			}
		?>
		

		<?php
			$loader = ((is_page_template() && get_post_meta(get_the_ID(), 'architek_enable_custom_header_options_value', true) == "yes") || (is_single() && get_post_meta(get_the_ID(), 'architek_enable_custom_header_options_value', true) == "yes")) ? get_post_meta(get_the_ID(), 'architek_enable_website_loading_value', true) : get_option("architek_enable_website_loader");
			if ($loader == "on"){
				?>
				<div id="architek_website_load">
				  	<div class="spinner">
					  	<?php
						  	$divs = "";
						  	$howMany = 0;
						  	$spinner = get_option("architek_website_loader");
						  	switch($spinner){
								case "ball-clip-rotate": case "square-spin": case "ball-rotate": case "ball-scale": case "ball-scale-ripple":
									$howMany = 1;
								break;
								case "ball-clip-rotate-pulse": case "ball-clip-rotate-multiple": case "cube-transition": case "ball-zig-zag":
									$howMany = 2;
								break;
								case "ball-pulse": case "ball-triangle-path": case "ball-scale-multiple": case "ball-pulse-sync": case "ball-beat": case "ball-scale-ripple-multiple":
									$howMany = 3;
								break;
								case "line-scale-party":
									$howMany = 4;
								break;
								case "ball-pulse-rise": case "line-scale": case "line-scale-pulse-out": case "line-scale-pulse-out-rapid": case "pacman":
									$howMany = 5;
								break;
								case "ball-spin-fade-loader": case "line-spin-fade-loader":
									$howMany = 8;
								break;
								case "ball-grid-pulse":
									$howMany = 9;
								break;
							}
							for ($i=0; $i<$howMany; $i++) $divs .= "<div class='loader_build_helper-{$i}'></div>";
							
							if ($spinner == "load2" || $spinner == "load3" || $spinner == "load6"){
								echo wp_kses('<div class="loaders-style-box '.$spinner.'"><div class="loader"></div></div>', 'post');
							} else {
								echo wp_kses('<div class="loaders-style-box loader-inner '.$spinner.'">'.$divs.'</div>', 'post');
							}
					  	?>
					</div>
					<?php
						if (get_option("architek_enable_website_loader_percentage") == "on"){
							?>
							<div class="percentage">0%</div>
							<?php
						}
					?>
			  	</div>
				<?php
			}
		?>
		
		<?php
			if (get_option("architek_body_type") == "body_boxed" && get_option('architek_header_style_type')!='style9'){
				?>
				<div class="boxed_layout">
				<?php
			}
		?>