<?php
	
function architek_print_menu($ispagephp = true, $isfirstpage = false){
	global $architek_header_bgstyle_pre, $architek_header_bgstyle_after;
	$header_shrink = "";
	$header_after_scroll = false;
	$typeofheader = get_option("architek_header_style_type");
	$architek_underlining_effect = get_option("architek_menu_underline_".$architek_header_bgstyle_pre,"on") == "on" ? " architek-underlining " : "";
	$header_fixed_helper = get_option('architek_fixed_menu', 'off') == 'off' ? false : true;
	$architek_header_hide_on_start = $architek_content_at_top = false;
	?>
	
	<header class="header-init navbar navbar-default navbar-fixed-top <?php echo esc_attr($typeofheader . $architek_underlining_effect); ?> <?php if (get_option('architek_fixed_menu') == 'off') echo " header_not_fixed"; else if ($architek_header_hide_on_start) echo " hide-on-start"; ?><?php if (get_option("architek_header_full_width") == "on") echo " header-full-width"; ?><?php if (get_option("architek_header_full_width") == "off") echo " header-with-container"; ?><?php if (get_option("architek_header_menu_itens_style") == "rounded") echo " menu-rounded"; ?><?php if (get_option("architek_header_menu_itens_style") == "simple") echo " menu-simple"; ?><?php if (get_option("architek_header_menu_itens_style") == "square") echo " menu-square"; ?><?php echo " ".esc_attr($architek_header_bgstyle_pre); ?><?php if ($architek_content_at_top) echo " header-init-force-fixed "; ?>" data-rel="<?php echo esc_attr($architek_header_bgstyle_pre."|".$architek_header_bgstyle_after); ?>">
		
		<?php
		if (get_option("architek_info_above_menu") == "on"){
			?>
			<div class="top-bar">
				<div class="top-bar-bg">
					<div class="<?php if (get_option("architek_header_full_width") == "off") echo "container"; ?> clearfix">
						<div class="slidedown">
						    <div class="col-xs-12 col-sm-12">
							<?php
								
								/* wpml menu */
								if (get_option("architek_wpml_menu_widget") == "on") {
									if (function_exists('icl_object_id')) { ?>
										<div class="menu_wpml_widget">	
											<?php if (function_exists('icl_language_selector')) do_action('icl_language_selector'); else if (function_exists('wpml_add_language_selector')) do_action('wpml_add_language_selector'); ?>
										</div>
									<?php 
									}
								}
								/* social icons */
								if (get_option("architek_enable_socials") == "on"){
									?>
										<div class="social-icons-fa">
									        <ul>
											<?php
												$icons = array(array("facebook","Facebook"),array("twitter","Twitter"),array("tumblr","Tumblr"),array("stumbleupon","Stumble Upon"),array("flickr","Flickr"),array("blogger","Blogger"),array("linkedin","LinkedIn"),array("delicious","Delicious"),array("skype","Skype"),array("digg","Digg"),array("google-plus","Google+"),array("vimeo-square","Vimeo"),array("deviantart","DeviantArt"),array("behance","Behance"),array("instagram","Instagram"),array("wordpress","WordPress"),array("youtube","Youtube"),array("reddit","Reddit"),array("rss","RSS"),array("soundcloud","SoundCloud"),array("pinterest","Pinterest"),array("dribbble","Dribbble"));
												foreach ($icons as $i){
													if (is_string(get_option("architek_icon-".$i[0])) && get_option("architek_icon-".$i[0]) != ""){
													?>
													<li>
														<a href="<?php echo esc_url(get_option("architek_icon-".$i[0])); ?>" target="_blank" class="social-network <?php echo esc_attr(strtolower($i[0])); ?>" title="<?php echo esc_attr($i[1]); ?>"><i class="fa fa-<?php echo esc_attr(strtolower($i[0])); ?>"></i></a>
													</li>
													<?php
													}
												}
											?>
										    </ul>
										</div>
									<?php	
								}
								/* company infos */
								if ( get_option("architek_telephone_menu") != "" || get_option("architek_email_menu") != "" || get_option("architek_address_menu") != "" || get_option("architek_text_field_menu") != "" ){
									?>
									<ul class="phone-mail">
										<?php if ( is_string(get_option("architek_telephone_menu")) && get_option("architek_telephone_menu") != "" ){ ?>
											<li><div class="icon dripicons-phone"></div><?php printf(esc_html__("%s", "architek"), get_option("architek_telephone_menu")); ?></li>
										<?php } ?>
										<?php if ( is_string(get_option("architek_email_menu")) && get_option("architek_email_menu") != "" ){ ?>
											<li><div class="icon dripicons-message"></div><a href="mailto:<?php echo esc_attr(get_option("architek_email_menu")); ?>"><?php echo esc_html(get_option("architek_email_menu")); ?></a></li>
										<?php } ?>
										<?php if ( is_string(get_option("architek_address_menu")) && get_option("architek_address_menu") != "" ){ ?>
											<li><div class="icon dripicons-pin"></div><?php echo wp_kses(get_option("architek_address_menu"), 'post'); ?></li>
										<?php } ?>
										<?php if ( is_string(get_option("architek_text_field_menu")) && get_option("architek_text_field_menu") != "" ){ ?>
											<li class="text_field"><?php echo wp_kses(get_option("architek_text_field_menu"), 'post'); ?></li>
										<?php } ?>
									</ul>
									<?php
								}
								
								
								/* topbar menu */
								if (get_option("architek_top_bar_menu") == "on"){
									?>
									<div class="top-bar-menu">
										<?php wp_nav_menu( array( 'theme_location' => 'topbarnav', 'container' => false, 'menu_class' => 'sf-menu', 'menu_id' => 'menu_top_bar' )); ?>
									</div>
									<?php
								}
							?>
							</div>
						</div>
					</div>
				</div>
				<a href="#" class="down-button"><i class="fa fa-plus"></i></a><!-- this appear on small devices -->
			</div>
			<?php
		}
		
		
		?>
		
		<div class="nav-container <?php if (get_option("architek_header_full_width") == "off") echo " container"; ?>">
			<div class="navbar-header">

				<a class="navbar-brand nav-to" href="<?php echo esc_url(home_url("/")); ?>" tabindex="-1">
				<?php 
					$architek_header_style_pre = $architek_header_bgstyle_pre == 'dark' ? 'light' : 'dark';
					$architek_header_style_after = $architek_header_bgstyle_after == 'dark' ? 'light' : 'dark';
					
					$alone = true;
					if (get_option("architek_logo_retina_image_url_".$architek_header_style_pre) != ""){
						$alone = false;
					}
					?>
					<img class="logo_normal <?php if (!$alone) echo "notalone"; ?>" src="<?php echo esc_url(get_option("architek_logo_image_url_".$architek_header_style_pre)); ?>" alt="<?php esc_attr_e("", "architek"); ?>" >
	
					<?php 
					if (get_option("architek_logo_retina_image_url_".$architek_header_style_pre) != ""){
					?>
						<img class="logo_retina" src="<?php echo esc_url(get_option("architek_logo_retina_image_url_".$architek_header_style_pre)); ?>" alt="<?php esc_attr_e("", "architek"); ?>" >
					<?php
					}
					/* architek_header_after_scroll option */
					if ($header_after_scroll || $architek_header_hide_on_start){
						$alone = true;
						if (get_option("architek_logo_retina_image_url_".$architek_header_style_after) != ""){
							$alone = false;
						}
						?>
						<img class="logo_normal logo_after_scroll <?php if (!$alone) echo "notalone"; ?>" alt="<?php esc_attr_e("", "architek"); ?>"  src="<?php echo esc_url(get_option("architek_logo_image_url_".$architek_header_style_after)); ?>">
	
						<?php 
						if (get_option("architek_logo_retina_image_url_".$architek_header_style_after) != ""){
						?>
							<img class="logo_retina logo_after_scroll" src="<?php echo esc_url(get_option("architek_logo_retina_image_url_".$architek_header_style_after)); ?>" alt="<?php esc_attr_e("", "architek"); ?>" >
						<?php
						}
					}
				?>
				</a>
			</div>
			
			
			
			<div class="architek_right_header_icons <?php
				if (class_exists( 'WooCommerce' ) && get_option("architek_woocommerce_cart") == "on") echo "with-woocommerce-cart";
			?>">
			
				<?php
					/* header button */
					if (get_option('architek_header_button') == 'on'){
						?>
						<div class="architek-header-button">
							<a href="<?php echo esc_url(get_option('architek_header_button_link')); ?>" class="nav-to"><?php 
								if (function_exists('icl_t')){
									printf(esc_html__("%s","architek"), icl_t( 'architek', 'Header Button', get_option('architek_header_button_text')));
								} else {
									printf(esc_html__("%s","architek"), get_option("architek_header_button_text"));
								} ?>
							</a>
						</div>
						<?php
					}
				?>
			
				<div class="header_social_icons <?php if (get_option("architek_social_icons_menu") == "on") echo "with-social-icons"; ?>">
					<?php
						if (get_option("architek_social_icons_menu") == "on" ){
							?>
						<div class="header_social_icons_wrapper">
							<?php
								$icons = array_reverse(array(array("facebook","Facebook"),array("twitter","Twitter"),array("tumblr","Tumblr"),array("stumbleupon","Stumble Upon"),array("flickr","Flickr"),array("linkedin","LinkedIn"),array("delicious","Delicious"),array("skype","Skype"),array("digg","Digg"),array("google-plus","Google+"),array("vimeo-square","Vimeo"),array("deviantart","DeviantArt"),array("behance","Behance"),array("instagram","Instagram"),array("wordpress","WordPress"),array("youtube","Youtube"),array("reddit","Reddit"),array("rss","RSS"),array("soundcloud","SoundCloud"),array("pinterest","Pinterest"),array("dribbble","Dribbble")));
								foreach ($icons as $i){
									if (is_string(get_option("architek_icon-".$i[0])) && get_option("architek_icon-".$i[0]) != ""){
									?>
										<div class="social_container <?php echo esc_attr(strtolower($i[0])); ?>_container" data-href="<?php echo esc_attr(esc_url(get_option('architek_icon-'.$i[0]))); ?>">
											<i class="fa fa-<?php echo esc_attr(strtolower($i[0])); ?>"></i>
										</div>
								<?php
								}
							}
							$architek_inline_script = '
								jQuery(document).ready(function(){
									"use strict";
									jQuery(document).on("click", ".header_social_icons_wrapper .social_container", function(){
										window.open( jQuery(this).attr("data-href"), "_blank" );
									});
								});
							';
							wp_add_inline_script('architek-global', $architek_inline_script, 'after');
							?>	
						</div>
						<?php
					}
				?>
				</div>
				
				<?php
					//search trigger
					if (get_option("architek_enable_search") == "on"){
						?>
						<div class="search_trigger"><div class="icon dripicons-search"></div></div>
						<?php
					}
				?>
				
				<?php architek_print_woocommerce_button();?>
				
				<?php
				if (get_option("architek_sliding_panel") == "on" && (function_exists('dynamic_sidebar') && is_active_sidebar( 'sliding_panel_sidebar' ))){
					?>					
						<div class="menu-controls sliderbar-menu-controller" title="Sidebar Menu Controller">
							<div class="font-icon custom-font-icon">
								<span class="hamburguer-trigger-menu-icon">   
									<span class="hamburguer-line hamburger-line-1"></span>
									<span class="hamburguer-line hamburger-line-2"></span>
									<span class="hamburguer-line hamburger-line-3"></span>
								</span>
							</div>
						</div>
					<?php
				}
				?>
				
				
			
			</div>
			<div id="dl-menu" class="dl-menuwrapper">
				<div class="dl-trigger-wrapper">
					<button class="dl-trigger">
						<span class="hamburguer-trigger-menu-icon">   
							<span class="hamburguer-line hamburger-line-1"></span>
							<span class="hamburguer-line hamburger-line-2"></span>
							<span class="hamburguer-line hamburger-line-3"></span>
						</span>
					</button>
				</div>
				<?php 
					if ($ispagephp){
						wp_nav_menu( array( 'theme_location' => 'PrimaryNavigation', 'container' => false, 'menu_class' => 'dl-menu', 'walker' => new architek_walker_nav_menu_outsider_mobile, 'fallback_cb' => esc_html__('You need to assign a Menu to the Main Navigation Location.','architek') ) );
					} 
					else {
						global $homes;
						$homes = 0;
						wp_nav_menu( array( 'theme_location' => 'PrimaryNavigation', 'container' => false, 'menu_class' => 'dl-menu', 'walker' => new architek_walker_nav_menu_mobile, 'fallback_cb' => esc_html__('You need to assign a Menu to the Main Navigation Location.','architek') ) );
					} 
				?>
			</div>
		</div>
		
	</header>
	
	<div class="header_style8_contents_bearer <?php if ($header_fixed_helper) echo esc_attr( 'menu_is_fixed' ); ?>">
		<div class="header_style8_left">
			<div class="header_style8_left_container">
				<?php
					if (!$isfirstpage){
						?>
						<div id="dl-menu" class="dl-menuwrapper">
							<div class="dl-trigger-wrapper">
								<button class="dl-trigger">
									<span class="hamburguer-trigger-menu-icon">   
										<span class="hamburguer-line hamburger-line-1"></span>
										<span class="hamburguer-line hamburger-line-2"></span>
										<span class="hamburguer-line hamburger-line-3"></span>
									</span>
								</button>
							</div>
							<?php 
								if ($ispagephp){
									wp_nav_menu( array( 'theme_location' => 'PrimaryNavigation', 'container' => false, 'menu_class' => 'dl-menu', 'walker' => new architek_walker_nav_menu_outsider_mobile, 'fallback_cb' => esc_html__('You need to assign a Menu to the Main Navigation Location.','architek') ) );
								} 
								else {
									global $homes;
									$homes = 0;
									wp_nav_menu( array( 'theme_location' => 'PrimaryNavigation', 'container' => false, 'menu_class' => 'dl-menu', 'walker' => new architek_walker_nav_menu_mobile, 'fallback_cb' => esc_html__('You need to assign a Menu to the Main Navigation Location.','architek') ) );
								} 
							?>
						</div>
						<?php
					}
				?>
				
				<div class="navbar-collapse collapse">
					<?php 
						if (!$isfirstpage){
							if ($ispagephp){
								wp_nav_menu( array( 'theme_location' => 'PrimaryNavigation', 'container' => false, 'menu_class' => 'nav navbar-nav navbar-right', 'walker' => new architek_walker_nav_menu_outsider, 'fallback_cb' => esc_html__('You need to assign a Menu to the Main Navigation Location.','architek') ) );
							} 
							else {
								global $homes;
								$homes = 0;
								wp_nav_menu( array( 'theme_location' => 'PrimaryNavigation', 'container' => false, 'menu_class' => 'nav navbar-nav navbar-right', 'walker' => new architek_walker_nav_menu, 'fallback_cb' => esc_html__('You need to assign a Menu to the Main Navigation Location.','architek') ) );
							}
						}
						
						// menu effects helpers
						$architek_inline_script = '
							jQuery(document).ready(function(){
								"use strict";
								if (jQuery("#architek-custom-style-inline-css").hasClass("submenus-added")) return;
								var css_helper = "";
								jQuery(".header_style8_left_container .nav li > ul").each(function(e){
									var classes = jQuery(this).attr("class").split(" "),
										menuDepth =  classes.filter(function (v) {return /menu-depth-/.test(v)});
									if (menuDepth && parseInt(menuDepth[0].replace("menu-depth-",""),10) > 1 && jQuery(this).closest(".architek_mega_menu").length) return;
									jQuery(this).addClass("submenu-helper-"+e);
										var thisHeight = jQuery(this).height();
										css_helper += ".submenu-helper-"+e+"{ border-top: "+thisHeight*(1/2)+"px solid transparent !important; border-bottom: "+thisHeight*(1/2)+"px solid transparent !important; height: "+thisHeight+"px; overflow: hidden; }";
								});
								jQuery("#architek-custom-style-inline-css").html( jQuery("#architek-custom-style-inline-css").html() + css_helper );
								jQuery(window).on("resize", function(){ 
									if (!jQuery("#architek-custom-style-inline-css-resizer").length) jQuery("#architek-custom-style-inline-css").after("<style id=\"architek-custom-style-inline-css-resizer\" />");
									var css_helper = "";
									jQuery(".header_style8_left_container .nav li.architek_mega_menu > ul").each(function(e){
										jQuery(this).addClass("submenu-helper-resizer-"+e);
										var maxHeight = 0;
										jQuery(this).children("li").each(function(){ if (jQuery(this).height() > maxHeight) maxHeight = jQuery(this).height(); });
										css_helper += ".submenu-helper-resizer-"+e+"{ border-top: "+maxHeight*(1/2)+"px solid transparent !important; border-bottom: "+maxHeight*(1/2)+"px solid transparent !important; height: "+maxHeight+"px; overflow: hidden; }";
									});
									jQuery("#architek-custom-style-inline-css-resizer").html(css_helper);
								});
								jQuery("#architek-custom-style-inline-css").addClass("submenus-added");
							';
							
						$architek_inline_script .= '
							});';
						wp_add_inline_script( 'architek-global', $architek_inline_script, 'after' );
					?>
				</div>
			</div>
		</div><!--  endof left -->
		<div class="header_style8_right">
			
	<?php
}
	
?>