<?php
	
/*-----------------------------------------------------------------------------------*/
/*  Architek Theme Styles
/*-----------------------------------------------------------------------------------*/

function architek_custom_style() {
	
	global $architek_custom, $architek_styleColor, $post, $architek_import_fonts, $architek_header_bgstyle_pre, $architek_header_bgstyle_after;
	$architek_theid = get_the_ID();
	$architek_styleColor = "#".get_option("architek_style_color");
	if ("#".get_option("architek_style_color") != $architek_styleColor) $architek_styleColor = "#".get_option("architek_style_color");
	$architek_color_code = substr($architek_styleColor,1);
	$architek_styleColor_rgb = architek_hex2rgb($architek_styleColor);

	$architek_headerType = get_option("architek_header_type");
	
	$architek_header_bgstyle_pre = get_option('architek_header_style_light_dark', 'light') == 'light' ? 'light' : 'dark';
	$architek_header_bgstyle_after = get_option('architek_header_after_scroll_style_light_dark', 'light') == 'light' ? 'light' : 'dark';
	
	if (is_singular() && get_post_meta($architek_theid, 'architek_enable_custom_header_options_value', true) == 'yes'){
		$architek_header_bgstyle_pre = get_post_meta($architek_theid, 'architek_custom_header_pre_value', true);
		$architek_header_bgstyle_after = get_post_meta($architek_theid, 'architek_custom_header_after_value', true);
	}
	
	$architek_header_style_pre = $architek_header_bgstyle_pre == 'dark' ? 'light' : 'dark';
	$architek_header_style_after = $architek_header_bgstyle_after == 'dark' ? 'light' : 'dark';
	
	global $architek_import_fonts;
	
	$architek_style_data = "";
	
	$architek_style_data .= ".widget li a:after, .widget_nav_menu li a:after, .custom-widget.widget_recent_entries li a:after{
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_p_color"))).";
	}
	body, p, .lovepost a, .widget ul li a, .widget p, .widget span, .widget ul li, .the_content ul li, .the_content ol li, #recentcomments li, .custom-widget h4, .widget.des_cubeportfolio_widget h4, .widget.des_recent_posts_widget h4, .custom-widget ul li a, .aio-icon-description, li, .smile_icon_list li .icon_description p, #recentcomments li span, .wpb-js-composer .vc_tta-color-grey.vc_tta-style-classic .vc_tta-panel .vc_tta-panel-title>a, .related_posts_listing .related_post .excerpt,
	.testimonials-slide-content .text-container span p, .testimonials-slide-content .text-container span, .testimonials-slide-content .text-container p{
		";
		
		$font = get_option('architek_p_font'); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; if (!isset($font[1])) $font[1] = "" ;
		$architek_style_data .= "
		font-family: '".wp_kses($font[0], 'post')."';
		font-weight: ".esc_html($font[1]).";
		font-size: ".esc_html(intval(get_option('architek_p_size'), 10))."px;
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_p_color"))).";
	}
	.page_content.sidebar .tagcloud a{
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_p_color"))).";

	}
	.map_info_text{
		";
		$font = get_option('architek_p_font'); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; if (!isset($font[1])) $font[1] = "";
		$architek_style_data .= "
		font-family: '".wp_kses($font[0], 'post')."' ,sans-serif;
		font-weight: ".esc_html($font[1]).";
		font-size: ".esc_html(intval(get_option('architek_p_size')), 10)."px;
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_p_color")))." !important;
	}
	.woocommerce ul.products li.product .price ins, .woocommerce-page ul.products li.product .price ins,
	.woocommerce #content div.product p.price ins, .woocommerce #content div.product span.price ins, .woocommerce div.product p.price ins, .woocommerce div.product span.price ins, .woocommerce-page #content div.product p.price ins, .woocommerce-page #content div.product span.price ins, .woocommerce-page div.product p.price ins, .woocommerce-page div.product span.price ins,
	.woocommerce-page ul.product_list_widget ins,
	.woocommerce ul.products li.product .price ins{
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_p_color")))." !important;
		background: transparent !important;

	}
	
	a.pageXofY .pageX, .pricing .bestprice .name, .filter li a:hover, .widget_links ul li a:hover, #contacts a:hover, .title-color, .ms-staff-carousel .ms-staff-info h4, .filter li a:hover, .navbar-default .navbar-nav > .open > a, .navbar-default .navbar-nav > .open > a:hover, .navbar-default .navbar-nav > .open > a:focus, a.go-about:hover, .text_color, .navbar-nav .dropdown-menu a:hover, .profile .profile-name, #elements h4, #contact li a:hover, #agency-slider h5, .ms-showcase1 .product-tt h3, .filter li a.active, .contacts li i, .big-icon i, .navbar-default.dark .navbar-brand:hover,.navbar-default.dark .navbar-brand:focus, a.p-button.border:hover, .navbar-default.light-menu .navbar-nav > li > a.selected, .navbar-default.light-menu .navbar-nav > li > a.hover_selected, .navbar-default.light-menu .navbar-nav > li > a.selected:hover, .navbar-default.light-menu .navbar-nav > li > a.hover_selected:hover, .navbar-default.light-menu .navbar-nav > li > a.selected, .navbar-default.light-menu .navbar-nav > li > a.hover_selected, .navbar-default.light-menu .navbar-nav > .open > a,.navbar-default.light-menu .navbar-nav > .open > a:hover, .navbar-default.light-menu .navbar-nav > .open > a:focus, .light-menu .dropdown-menu > li > a:focus, a.social:hover:before, .symbol.colored i, .icon-nofill, .slidecontent-bi .project-title-bi p a:hover, .grid .figcaption a.thumb-link:hover, .tp-caption a:hover, .btn-1d:hover, .btn-1d:active, #contacts .tweet_text a, #contacts .tweet_time a, .social-font-awesome li a:hover, h2.post-title a:hover, .tags a:hover, .architek-button-color span, #contacts .form-success p, .nav-container .social-icons-fa a i:hover, .the_title h2 a:hover, .widget ul li a:hover, .des-pages .postpagelinks, .widget_nav_menu .current-menu-item > a, .team-position, .nav-container .architek_minicart li a:hover, body.style9 .architek_minicart li a:hover, .metas-container i, .header_style2_contact_info .telephone-contact .email, .widget-contact-content i,.woocommerce.widget_shopping_cart ul.cart_list li a:hover, .woocommerce.widget_shopping_cart ul.product_list_widget li a:hover,
	.woocommerce ul.products li.product a.add_to_cart_button.ajax_add_to_cart:hover:after, 
.woocommerce-page ul.products li.product a.add_to_cart_button.ajax_add_to_cart:hover:after,
.woocommerce ul.products li.product a.product_type_variable:hover:after, 
.woocommerce-page ul.products li.product a.product_type_variable:hover:after,
.woocommerce ul.products li.product a.product_type_grouped:hover:after, 
.woocommerce-page ul.products li.product a.product_type_grouped:hover:after{
	  color: ".esc_html($architek_styleColor).";
	}

	
	body .ls-roundedflat .ls-nav-prev:hover, body .ls-roundedflat .ls-nav-next:hover,
	body .ls-roundedflat .ls-bottom-slidebuttons a.ls-nav-active, body .ls-roundedflat .ls-bottom-slidebuttons a:hover,
	.widget > h2:after, .widget > h4:after, .custom-widget > h4:after, .widget .widget-contact-content > h4:after, #footer-instagram p.clear a,
	.woocommerce #content input.button.alt:hover, .woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover, .woocommerce-page #content input.button.alt:hover, .woocommerce-page #respond input#submit.alt:hover, .woocommerce-page a.button.alt:hover, .woocommerce-page button.button.alt:hover, .woocommerce-page input.button.alt:hover, .footer_newsletter form input.button, .cd-overlay-content span, .cd-nav-bg-fake, .errorbutton:hover, .newsletter_shortcode form input.button, .architek-labeled h4,.top-bar .phone-mail li.text_field,.widget-contact-content.centered i, .colored_bg,
	.flex-direction-nav a.flex-next:hover:after,
	.flex-direction-nav a.flex-prev:hover:after,
	.architek_recent_posts .post-quote,
	.cbp-popup-singlePageInline .cbp-popup-close:hover:after{
		background: ".esc_html($architek_styleColor)." !important;
		color: #fff !important;
	}
	
	.cbp-popup-lightbox .cbp-popup-prev:hover, .cbp-popup-lightbox .cbp-popup-next:hover,.cbp-popup-lightbox .cbp-popup-close:hover{
		background-color: ".esc_html($architek_styleColor)." !important;
	}
	.testimonials.style1 .testimonial span a, .metas a:hover, .vc_tta-color-grey.vc_tta-style-classic .vc_tta-panel.vc_active .vc_tta-panel-title>a, .related_posts_listing .related_post .title:hover, .architek_breadcrumbs a:hover, .mail-box .news-l .opacity-icon i,  div.nav-style-6 > ul > .menu_items_wrapper > li > a:hover,a.aio-icon-read:hover, .t-author a,.testimonials-slide-content .img-container:after,.page-template-blog-masonry-template .posts_category_filter li:hover, .page-template-blog-masonry-grid-template .posts_category_filter li:hover, .posts_category_filter li.selected, .dark .header_style2_contact_info .email-contact .email a:hover, single-post .post a:hover,.des_recent_posts_widget.widget .title a:hover h4{
		color: ".esc_html($architek_styleColor)." !important;
	}
	.architek-form-simple.dark .bt-contact a span input:hover{
		border: 1px solid ".esc_html($architek_styleColor)." !important;
		background: ".esc_html($architek_styleColor)." !important;
	}
	
	.widget:not(.contact-widget-container):not(.instagram_widget):not(.recent_posts_widget_2) li a:hover:after, .widget_nav_menu li a:hover:after, .footer_sidebar ul li a:hover:after{
		border-bottom-color: ".esc_html($architek_styleColor)." !important;
	}
	
	.special_tabs.horizontal.text .tab-selector .label:hover .title a:before, .ult_btn10_span:hover:before, a.aio-icon-read:hover:before{
		border-bottom-color: ".esc_html($architek_styleColor)." !important;
	}
	
	.ult_cl_link_1 .ult_btn10_span:hover:before, .ult_cl_link_1 .ult_btn10_span:before{border:none !important;}
	
	.aio-icon-read, .tp-caption a.text_color{color: ".esc_html($architek_styleColor)." !important;}
	
	#big_footer .social-icons-fa a:not(.social-network) i{color:#".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_sec_footer_social_icons_color"))).";}
	#big_footer .social-icons-fa a:not(.social-network) i:hover{color:#".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_sec_footer_social_icons_hover_color"))).";}
	
	.homepage_parallax .home-logo-text a.light:hover, .homepage_parallax .home-logo-text a.dark:hover, .widget li a:hover:before, .widget_nav_menu li a:hover:before, .footer_sidebar ul li a:hover:before, .custom-widget li a:hover:before,
	.archive .the_title h2 a:hover, .page-template-blog-template .the_title h2 a:hover, .home.blog .blog-default.wideblog .container .the_title h2 a:hover,
	.blog-default-bg-masonry .the_title h2 a:hover, .product-title:hover,
	.testimonials.style1 .testimonial-nav li a.active:after,
	.post-listing .metas-container a:hover, 
	.special_tabs.icontext .label.current,
	.special_tabs.vertical:not(.icon) .label.current i,
	.special_tabs.vertical .label.current a, 
	.special_tabs.vertical:not(.icon) .label:hover i,
	.widget li a:hover, .widget_nav_menu li a:hover, .footer_sidebar ul li a:hover, .custom-widget li a:hover{
		color: ".esc_html($architek_styleColor)." !important;
	}
	
	
	a.sf-button.hide-icon, .tabs li.current, .readmore:hover, .navbar-default .navbar-nav > .open > a,.navbar-default .navbar-nav > .open > a:hover, .navbar-default .navbar-nav > .open > a:focus, a.p-button:hover, a.p-button.colored, .light #contacts a.p-button, .tagcloud a:hover, .rounded.fill, .colored-section, .pricing .bestprice .price, .pricing .bestprice .signup, .signup:hover, .divider.colored, .services-graph li span, .no-touch .hi-icon-effect-1a .hi-icon:hover, .hi-icon-effect-1b .hi-icon:hover, .no-touch .hi-icon-effect-1b .hi-icon:hover, .symbol.colored .line-left, .symbol.colored .line-right, .projects-overlay #projects-loader, .panel-group .panel.active .panel-heading, .double-bounce1, .double-bounce2, .architek-button-color-1d:after, .container1 > div, .container2 > div, .container3 > div, .cbp-l-caption-buttonLeft:hover, .cbp-l-caption-buttonRight:hover, .post-content a:hover .post-quote, .post-listing .post a:hover .post-quote, .architek-button-color-1d:after, .woocommerce .widget_price_filter .ui-slider-horizontal .ui-slider-range, .woocommerce-page .widget_price_filter .ui-slider-horizontal .ui-slider-range, .btn-contact-left input, #commentform .form-submit #submit:hover, .errorbutton, .woocommerce span.onsale, .woocommerce-page span.onsale, .des-button-dark, .des-pages .pages, .page-template-blog-template .post-quote, .single-post .post-quote,
	.bt-contact a span input,
	.page-template-blog-masonry-template .metas p[data-rel='metas-categories'] a,
	.home.blog .metas p[data-rel='metas-categories'] a,
	.page-template-blog-masonry-grid-template .metas p[data-rel='metas-categories'] a,
	.archive .masonry .metas p[data-rel='metas-categories'] a,
	.page-template-blog-masonry-template .metas p[data-rel='metas-tags'] a,
	.page-template-blog-masonry-grid-template .metas p[data-rel='metas-tags'] a,
	.post-listing .post .blog-default-bg-masonry .post-quote,
	.widget h2:after, .widget h4:after, .custom-widget h4:after,
	.woocommerce .woocommerce-info, .woocommerce-page .woocommerce-info,
	.nav-container a.button.architek_minicart_cart_but,
	body.style9 a.button.architek_minicart_cart_but,
	.nav-container a.button.architek_minicart_checkout_but,
	body.style9 a.button.architek_minicart_checkout_but,
	#pbd-alp-load-posts a:hover,
	#primary_footer .footer_sidebar > h4::before, #primary_footer .footer_sidebar > .widget > h4::before, #primary_footer .widget .widget-contact-content h4::before, #primary_footer .widget h4::before, #primary_footer .widget .widget-contact-content > h4::before, .widget > h2::before, .widget > h4::before, .custom-widget > h4::before,
	.select2-container--default .select2-results__option[data-selected=true], .special_tabs.horizontal.text .tab-selector .label:before,
	.dropdown-menu li.menu-item-has-children:not(.architek_mega_hide_link) > a:hover:after, .dropdown-menu li.menu-item-has-children:not(.architek_mega_hide_link) > a:focus:after, .dropdown-menu li.menu-item-has-children:not(.architek_mega_hide_link) > a:active:after, .dropdown-menu li:hover > a:after,
	.widget:not(.widget_recent_comments):not(.widget_rss) li a:hover::after, .widget_nav_menu li a:hover::after, .footer_sidebar ul li a:hover::after, .custom-widget li a:hover::after,
	.woocommerce ul.products li.product .onsale, .woocommerce-page ul.products li.product .onsale{
		background-color:".esc_html($architek_styleColor).";
	}
	.woocommerce .woocommerce-info .showcoupon{color: #fff !important;opacity:0.8;}
	.aio-icon-tooltip .aio-icon:hover:after{box-shadow:0 0 0 1px ".esc_html($architek_styleColor)." !important;}
	.just-icon-align-left .aio-icon:hover, .aio-icon-tooltip .aio-icon:hover, .btn-contact-left.inversecolor input:hover, .light .architek_little_shopping_bag .overview span.minicart_items, .architek_little_shopping_bag .overview span.minicart_items,
	#mc_embed_signup input#mc-embedded-subscribe:hover,
	#mc_embed_signup input#mc-embedded-subscribe:focus, .team_member_profile_content .aio-icon.circle:hover,
	.special_tabs.icon .current .architek_icon_special_tabs,
	.dropdown-menu li.menu-item-has-children:not(.architek_mega_hide_link) > a:hover:after,
			header .dropdown-menu li.menu-item-has-children:not(.architek_mega_hide_link) > a:focus:after,
			header .dropdown-menu li.menu-item-has-children:not(.architek_mega_hide_link) > a:active:after, 
			header .dropdown-menu li:hover > a:after, 
			.cbp-popup-singlePageInline .cbp-popup-close:hover{
				background-color:".esc_html($architek_styleColor)." !important;
	}
	.aio-icon-tooltip .aio-icon.none:hover{background-color: transparent !important;}
	
	.widget .slick-dots li.slick-active i, .related_posts_listing .slick-dots li.slick-active i{color: ".esc_html($architek_styleColor)." !important;opacity: 1;}
	
	
	.woocommerce-page a.button.wc-forward:hover, .woocommerce-page a.button.wc-forward.checkout:hover, .woocommerce .widget_price_filter .price_slider_amount .button:hover, .woocommerce-page .widget_price_filter .price_slider_amount .button:hover, .woocommerce #payment #place_order:hover, .woocommerce-page #payment #place_order:hover, .woocommerce .cart .button:hover, .woocommerce .checkout_coupon .button:hover, .woocommerce .cart input.button:hover, .woocommerce-page .cart .button:hover, .woocommerce-page .cart input.button:hover, .woocommerce .cart-collaterals .cart_totals a.button.alt:hover, .woocommerce-page .cart-collaterals .cart_totals a.button.alt:hover
	{
		background-color:".esc_html($architek_styleColor).";
		color: #fff !important;
	}
	.nav-container a.button.architek_minicart_checkout_but:hover, .nav-container a.button.architek_minicart_cart_but:hover,
	body.style9 a.button.architek_minicart_checkout_but:hover, body.style9 a.button.architek_minicart_cart_but:hover{
		background-color: ".esc_html($architek_styleColor)." !important;
		color: #fff !important;
		border: 1px solid transparent !important;
		opacity: 0.8;
	}
	.architek-button-color-1d:hover, .architek-button-color-1d:active{
		border: 1px double ".esc_html($architek_styleColor).";
	}
	
	.architek-button-color{
		background-color:".esc_html($architek_styleColor).";
		color: ".esc_html($architek_styleColor).";
	}
	.cbp-l-caption-alignCenter .cbp-l-caption-buttonLeft:hover, .cbp-l-caption-alignCenter .cbp-l-caption-buttonRight:hover, 
	.social-shares ul li i:hover, .single-portfolio .social-shares ul li a:hover i {
	    color: ".esc_html($architek_styleColor)." !important;
	}
	.widget_posts .tabs li.current{border: 1px solid ".esc_html($architek_styleColor).";}
	.hi-icon-effect-1 .hi-icon:after{box-shadow: 0 0 0 3px ".esc_html($architek_styleColor).";}
	.colored-section:after {border: 20px solid ".esc_html($architek_styleColor).";}
	.filter li a.active, .filter li a:hover, .panel-group .panel.active .panel-heading{border:1px solid ".esc_html($architek_styleColor).";}
	.navbar-default.light-menu.border .navbar-nav > li > a.selected:before, .navbar-default.light-menu.border .navbar-nav > li > a.hover_selected:before, .navbar-default.light-menu.border .navbar-nav > li > a.selected:hover, .navbar-default.light-menu.border .navbar-nav > li > a.hover_selected:hover, .navbar-default.light-menu.border .navbar-nav > li > a.selected, .navbar-default.light-menu.border .navbar-nav > li > a.hover_selected{
		border-bottom: 1px solid ".esc_html($architek_styleColor).";
	}
	
	.doubleborder{
		border: 6px double ".esc_html($architek_styleColor).";
	}
	
	.special_tabs.icon .current .architek_icon_special_tabs{
		border: 1px solid ".esc_html($architek_styleColor).";
	}
	.architek-button-color, .des-pages .postpagelinks{
		border: 1px solid ".esc_html($architek_styleColor).";
	}
	
	
	.navbar-collapse ul.menu-depth-1 li:not(.architek_mega_hide_link) a, .dl-menuwrapper li:not(.architek_mega_hide_link) a, .gosubmenu, .nav-container .architek_minicart ul li, body.style9 .architek_minicart ul li{";
		$font = get_option('architek_sub_menu_font'); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; if (!isset($font[1])) $font[1] = "";
		$architek_style_data .= "
		font-family: '".wp_kses($font[0], 'post')."', sans-serif;
		font-weight: ".esc_html($font[1]).";
		font-size: ".esc_html(intval(get_option('architek_sub_menu_font_size'),10))."px;
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option('architek_sub_menu_color'))).";";
		if (get_option('architek_sub_menu_uppercase') === 'on') $architek_style_data .= "text-transform: uppercase;\n";
		$architek_style_data .= "letter-spacing: ".esc_html(intval(get_option('architek_sub_menu_letter_spacing'),10))."px;
	}
	
	.nav-style-6 ul.menu-depth-1 li a {";
		$font = get_option('architek_sub_menu_font'); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; if (!isset($font[1])) $font[1] = "";
		$architek_style_data .= "
		font-family: '".wp_kses($font[0], 'post')."', sans-serif !important;
		font-weight: ".esc_html($font[1]).";
		font-size: ".esc_html(intval(get_option('architek_sub_menu_font_size'),10))."px !important;
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option('architek_sub_menu_color'))).";";
		if (get_option('architek_sub_menu_uppercase') === 'on') $architek_style_data .= "text-transform: uppercase;\n";
		$architek_style_data .= "letter-spacing: ".esc_html(intval(get_option('architek_sub_menu_letter_spacing'),10))."px;
	}
	
	.dropdown-menu li.menu-item-has-children:not(.architek_mega_hide_link) > a:before{
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option('architek_sub_menu_color'))).";
	}
	
	.dl-back{color: #".str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option('architek_sub_menu_color')).";}
	
	/* changed the overs from lis to as to acommodate style8 */
	.navbar-collapse ul.menu-depth-1 li:not(.architek_mega_hide_link) > a:hover, .dl-menu li:not(.architek_mega_hide_link):hover > a, .dl-menu li:not(.architek_mega_hide_link):hover > a, .dl-menu li:not(.architek_mega_hide_link):hover > .gosubmenu, .dl-menu li.dl-back:hover, .navbar-nav:not(.cd-primary-nav) .dropdown-menu a:hover i, .dropdown-menu li.menu-item-has-children:not(.architek_mega_hide_link) > a:hover:before{
		color: #".str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option('architek_sub_menu_color_hover'))." !important;
	}
	
	.dl-menu li:not(.architek_mega_hide_link):hover a:after{
		background-color: #".str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option('architek_sub_menu_color_hover'))." !important;
	}
		
	.menu-simple ul.menu-depth-1, .menu-simple ul.menu-depth-1 ul, .menu-simple ul.menu-depth-1, .menu-simple #dl-menu ul{";
		$color = architek_hex2rgb(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_sub_menu_bg_color")));
		$architek_style_data .= "background-color: rgba(".esc_html($color[0].",".$color[1].",".$color[2].",".intval(str_replace("%","",get_option("architek_sub_menu_bg_opacity")))/100).") !important;
	}
	
	.navbar-collapse .architek_mega_menu ul.menu-depth-2, .navbar-collapse .architek_mega_menu ul.menu-depth-2 ul {background-color: transparent !important;} 
	
	.dl-menuwrapper li:not(.architek_mega_hide_link):hover > a{";
		$color = architek_hex2rgb(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_sub_menu_bg_color_hover")));
		$architek_style_data .= "background-color: rgba(".esc_html($color[0].",".$color[1].",".$color[2].",".intval(str_replace("%","",get_option("architek_sub_menu_bg_color_hover_opacity")))/100).") !important;
	}
	
	.menu-simple li:not(.architek_mega_menu) li.menu-item-depth-1:hover > a, .menu-simple li.menu-item-depth-2:hover > a, .menu-simple li.menu-item-depth-3:hover > a{";
		$color = architek_hex2rgb(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_sub_menu_bg_color_hover")));
		$architek_style_data .= "background-color: rgba(".esc_html($color[0].",".$color[1].",".$color[2].",".intval(str_replace("%","",get_option("architek_sub_menu_bg_color_hover_opacity")))/100).") !important;
	}
	
	.menu-square li:not(.architek_mega_menu) li.menu-item-depth-1:hover > a, .menu-square li.menu-item-depth-2:hover > a, .menu-square li.menu-item-depth-3:hover > a{";
		$color = architek_hex2rgb(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_sub_menu_bg_color_hover")));
		$architek_style_data .= "background-color: rgba(".esc_html($color[0].",".$color[1].",".$color[2].",".intval(str_replace("%","",get_option("architek_sub_menu_bg_color_hover_opacity")))/100).") !important;
	}
	
	.navbar-collapse li:not(.architek_mega_menu) ul.menu-depth-1 li:not(:first-child){";
		$color = architek_hex2rgb(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_sub_menu_border_color")));
		$architek_style_data .= "border-top: 1px solid rgba(".esc_html($color[0].",".$color[1].",".$color[2].",".intval(str_replace("%","",get_option("architek_sub_menu_border_color_opacity")))/100).") !important;
	}
	
	.navbar-collapse li.architek_mega_menu ul.menu-depth-2{";
		$color = architek_hex2rgb(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_sub_menu_border_color")));
		$architek_style_data .= "border-right: 1px solid rgba(".esc_html($color[0].",".$color[1].",".$color[2].",".intval(str_replace("%","",get_option("architek_sub_menu_border_color_opacity")))/100).") !important;
	}
	
	.rtl .navbar-collapse li.architek_mega_menu ul.menu-depth-2{";
		$color = architek_hex2rgb(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_sub_menu_border_color")));
		$architek_style_data .= "border-left: 1px solid rgba(".esc_html($color[0].",".$color[1].",".$color[2].",".intval(str_replace("%","",get_option("architek_sub_menu_border_color_opacity")))/100).") !important;
	}
		
	#dl-menu ul li:not(:last-child) a, .architek_sub_menu_border_color,
	header.navbar .navbar-collapse li.architek_mega_menu li{";
		$color = architek_hex2rgb(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_sub_menu_border_color")));
		$architek_style_data .= "border-bottom: 1px solid rgba(".esc_html($color[0].",".$color[1].",".$color[2].",".intval(str_replace("%","",get_option("architek_sub_menu_border_color_opacity")))/100).") !important;
	}
	
	.navbar-collapse ul.navbar-nav > li > a, .navbar-collapse > .header_style2_menu > ul > li > a, .architek-header-button a, div.nav-style-6 > ul > .menu_items_wrapper > li > a {";
		$font = get_option('architek_menu_font_pre_'.$architek_header_style_pre); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; if (!isset($font[1])) $font[1] = "";
		$architek_style_data .= "
		font-family: '".wp_kses($font[0], 'post')."', sans-serif;
		font-weight: ".esc_html($font[1])." !important;
		font-size: ".esc_html(intval(get_option('architek_menu_font_size_pre_'.$architek_header_style_pre),10))."px;
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option('architek_menu_color_pre_'.$architek_header_style_pre))).";";
		if (get_option('architek_menu_uppercase_pre_'.$architek_header_style_pre) === 'on') $architek_style_data .= "text-transform: uppercase;\n"; else $architek_style_data .= "text-transform:none;\n";
		$architek_style_data .= "letter-spacing: ".esc_html(intval(get_option('architek_menu_letter_spacing_pre_'.$architek_header_style_pre),10))."px;
	}
	
	.architek-header-button a{
		background: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option('architek_header_button_bg_color'))).";
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option('architek_header_button_text_color'))).";
		-webkit-border-radius:".esc_html(get_option("architek_header_button_border_radius")).";-moz-border-radius:".esc_html(get_option("architek_header_button_border_radius")).";-ms-border-radius:".esc_html(get_option("architek_header_button_border_radius")).";-o-border-radius:".esc_html(get_option("architek_header_button_border_radius")).";border-radius:".esc_html(get_option("architek_header_button_border_radius")).";
	}
	.architek-header-button a:hover{
		background: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option('architek_header_button_bg_hover_color'))).";
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option('architek_header_button_text_hover_color')))." !important;
	}
	
	.navbar-collapse > .header_style2_menu > ul > li > a:hover, 
	.navbar-collapse > .header_style2_menu > ul > li.current-menu-ancestor > a, 
	.navbar-collapse > .header_style2_menu > ul > li.current-menu-item > a, 
	.navbar-collapse > .header_style2_menu > ul > li > a.selected,
	.navbar-collapse > .header_style2_menu > ul > li > a.hover_selected,
	.navbar-collapse ul.navbar-nav > li > a:hover, 
	.navbar-collapse ul.navbar-nav > li.current-menu-ancestor > a, 
	.navbar-collapse ul.navbar-nav > li.current-menu-item > a, 
	.navbar-collapse ul.navbar-nav > li > a.selected,
	.navbar-collapse ul.navbar-nav > li > a.hover_selected{
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option('architek_menu_color_hover_pre_'.$architek_header_style_pre)))." !important;
	}
	
	/* 2020 header borders */
	header.navbar:not(.header_after_scroll),
	header.navbar:not(.header_after_scroll) .navbar-right{ ";
		$color = architek_hex2rgb(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_header_border_color_".$architek_header_bgstyle_pre)));
		$architek_style_data .= "border-color: rgba(".esc_html($color[0].",".$color[1].",".$color[2].",".intval(str_replace("%","",get_option("architek_header_border_opacity_".$architek_header_bgstyle_pre)))/100).") !important;
	}
	
	header.navbar.header_after_scroll,
	header.navbar.header_after_scroll .navbar-right{ ";
		$color = architek_hex2rgb(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_header_after_scroll_border_color_".$architek_header_bgstyle_after)));
		$architek_style_data .= "border-color: rgba(".esc_html($color[0].",".$color[1].",".$color[2].",".intval(str_replace("%","",get_option("architek_header_after_scroll_border_opacity_".$architek_header_bgstyle_after)))/100).") !important;
	}
	/* endof 2020 header borders */
	
	.header.navbar .navbar-collapse ul li:hover a 
	{
		background: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option('architek_menu_color_hover_pre_'.$architek_header_style_pre))).";
		color: #fff !important;
	}
	
	header.navbar-default.architek-underlining .navbar-nav > li:hover > a:before,
	.navbar-collapse ul.navbar-nav > li.current-menu-item > a:before,
	.navbar-collapse ul.navbar-nav > li.current-menu-ancestor > a:before,
	.navbar-collapse ul.navbar-nav > li > a.selected:before{
		background: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option('architek_menu_color_hover_pre_'.$architek_header_style_pre)))." !important;
	}
	.dropdown-menu li.menu-item-has-children:not(.architek_mega_hide_link) > a:hover:after,
	.dropdown-menu li.menu-item-has-children:not(.architek_mega_hide_link) > a:focus:after,
	.dropdown-menu li.menu-item-has-children:not(.architek_mega_hide_link) > a:active:after, 
	.dropdown-menu li:hover > a:after{
				background: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option('architek_menu_color_hover_pre_'.$architek_header_style_pre)))." !important;
			}
	header.navbar-default.header_after_scroll.architek-underlining .navbar-nav > li:hover > a:before,
	header.navbar-default.header_after_scroll .navbar-collapse ul.navbar-nav > li.current-menu-item > a:before,
	header.navbar-default.header_after_scroll .navbar-collapse ul.navbar-nav > li.current-menu-ancestor > a:before,
	header.navbar-default.header_after_scroll .navbar-collapse ul.navbar-nav > li > a.selected:before{
		background: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option('architek_menu_color_hover_after_'.$architek_header_style_after)))." !important;
	}
	
	
	";
	
	if (get_option('architek_menu_add_border_pre_'.$architek_header_style_pre) == "on"){
		$architek_style_data .= ".navbar-collapse ul.menu-depth-1, .nav-container .architek_minicart, body.style9 .architek_minicart{padding-top:3px !important;border-top:1px solid #".str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option('architek_menu_border_color_pre_'.$architek_header_style_pre))." !important;}";
	}
	
	$architek_style_data .= "
	
	
	header.style2 .navbar-nav > li, .navbar-default.menu-square.style2 .navbar-nav > li {padding-top:0px;}
	header.style2{
		padding-bottom:".esc_html(intval(get_option('architek_menu_margin_top_pre_'.$architek_header_style_pre),10))."px;
	}
	header.style2 .header_style2_menu{
		margin-top:".esc_html(intval(get_option('architek_menu_margin_top_pre_'.$architek_header_style_pre),10))."px !important;
	}
	
	.navbar-default .navbar-nav > li > a{
		padding-top:".esc_html(intval(get_option('architek_menu_margin_top_pre_'.$architek_header_style_pre),10))."px;
		padding-bottom:".esc_html(intval(get_option('architek_menu_padding_bottom_pre_'.$architek_header_style_pre),10))."px;
		
	}
	
	.navbar-default .navbar-nav > li{
		padding-right:".esc_html(intval(get_option('architek_menu_side_margin_pre_'.$architek_header_style_pre),10))."px;
		padding-left:".esc_html(intval(get_option('architek_menu_side_margin_pre_'.$architek_header_style_pre),10))."px;
	}
	
	header .architek-header-button{margin-top:".esc_html(intval(get_option('architek_menu_margin_top_pre_'.$architek_header_style_pre),10))."px;}
	
	header.style5 .architek_right_header_icons,
	header.style1 .architek_right_header_icons,
	header.style2 .architek_right_header_icons,
	header.style4 .architek_right_header_icons,
	header.style6 .architek_right_header_icons,
	header.style7 .architek_right_header_icons{
		padding-top:".esc_html(intval(get_option('architek_menu_margin_top_pre_'.$architek_header_style_pre),10))."px;
		padding-bottom:".esc_html(intval(get_option('architek_menu_padding_bottom_pre_'.$architek_header_style_pre),10))."px;
		
	}
	
	header .architek_right_header_icons{
		margin-left: 30px;
		
	}
	body #big_footer .tagcloud a:hover{color:#fff !important;}
	header.style2 .header_style2_menu{ ";
	$color = architek_hex2rgb(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_sub_menu_bg_color")));
	$architek_style_data .= "background-color: rgba(".esc_html($color[0].",".$color[1].",".$color[2].",".intval(str_replace("%","",get_option("architek_sub_menu_bg_opacity")))/100).") !important;
	}
	
	header:not(.header_after_scroll) .navbar-nav > li > ul{
		margin-top:".esc_html(intval(get_option('architek_menu_padding_bottom_pre_'.$architek_header_style_pre),10))."px;
	}

	header:not(.header_after_scroll) .dl-menuwrapper button:after{
		background: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option('architek_menu_color_hover_pre_'.$architek_header_style_pre))).";
		box-shadow: 0 6px 0 #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option('architek_menu_color_hover_pre_'.$architek_header_style_pre))).", 0 12px 0 #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option('architek_menu_color_hover_pre_'.$architek_header_style_pre))).";
	}

	.architek_minicart_wrapper{
		padding-top: ".esc_html(intval(get_option('architek_menu_padding_bottom_pre_'.$architek_header_style_pre),10))."px;
	}
	
	li.architek_mega_hide_link > a, li.architek_mega_hide_link > a:hover{";
		$font = get_option('architek_label_menu_font'); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; if (!isset($font[1])) $font[1] = "";
		$architek_style_data .= "
		font-family: '".wp_kses($font[0], 'post')."' !important;
		font-weight: ".esc_html($font[1])." !important;
		font-size: ".esc_html(intval(get_option('architek_label_menu_font_size'),10))."px !important;
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option('architek_label_menu_color'))).";";
		if (get_option('architek_label_menu_uppercase') === 'on') $architek_style_data .= "text-transform: uppercase !important;\n";
		$architek_style_data .= "letter-spacing: ".esc_html(intval(get_option('architek_label_menu_letter_spacing'),10))."px !important;
	}
	
	.nav-container .architek_minicart li a, body.style9 .architek_minicart li a{";
		$font = get_option('architek_sub_menu_font'); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; if (!isset($font[1])) $font[1] = "";
		$architek_style_data .= "
		font-family: '".wp_kses($font[0], 'post')."';
		font-weight: ".esc_html($font[1]).";
		font-size: ".esc_html(intval(get_option('architek_sub_menu_font_size'),10))."px;
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option('architek_sub_menu_color'))).";";
		if (get_option('architek_sub_menu_uppercase') === 'on') $architek_style_data .= "text-transform: uppercase;\n";
		$architek_style_data .= "letter-spacing: ".esc_html(intval(get_option('architek_sub_menu_letter_spacing')),10)."px;
	}
	
	.dl-trigger{";
		$font = get_option('architek_menu_font_pre_'.$architek_header_style_pre); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; if (!isset($font[1])) $font[1] = "";
		$architek_style_data .= "
		font-family: '".wp_kses($font[0], 'post')."' !important;
		font-weight: ".esc_html($font[1])." !important;
		font-size: ".esc_html(intval(get_option('architek_menu_font_size_pre_'.$architek_header_style_pre),10))."px;";
		if (get_option('architek_menu_uppercase_pre_'.$architek_header_style_pre) === 'on') $architek_style_data .= "text-transform: uppercase;\n";
		$architek_style_data .= "letter-spacing: ".esc_html(intval(get_option('architek_menu_letter_spacing_pre_'.$architek_header_style_pre),10))."px;
	}
	
	.architek_minicart{";
		$color = architek_hex2rgb(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_sub_menu_bg_color")));
		$architek_style_data .= "background-color: rgba(".esc_html($color[0].",".$color[1].",".$color[2].",".intval(str_replace("%","",get_option("architek_sub_menu_bg_opacity")))/100).") !important;
	}
	
	.page_content a, header a, #big_footer a, .comment-body a, .logged-in-as a, #reply-title a{";
		$font = get_option('architek_links_font'); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; if (!isset($font[1])) $font[1] = "";
		$architek_style_data .= "
		font-family: '".wp_kses($font[0], 'post')."';
		font-weight: ".esc_html($font[1]).";
		font-size: ".esc_html(intval(get_option('architek_links_size'), 10))."px;
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_links_color")))."
	}
	
	.page_content a:hover, .comment-body a:hover, .logged-in-as a:hover, #reply-title a:hover{";
		$font = get_option('architek_links_font'); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; if (!isset($font[1])) $font[1] = "";
		$architek_style_data .= "
		font-family: '".wp_kses($font[0], 'post')."';
		font-weight: ".esc_html($font[1]).";
		font-size: ".esc_html(intval(get_option('architek_links_size'), 10))."px;
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_links_color_hover")))."
	}
	
	
	.archive .the_title h2 a, .page-template-blog-template .the_title h2 a, .home.blog .blog-default.wideblog .container .the_title h2 a{";
		$font = get_option('architek_blog_normal_title_font'); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; if (!isset($font[1])) $font[1] = "";
		$architek_style_data .= "
		font-family: '".wp_kses($font[0], 'post')."';
		font-weight: ".esc_html($font[1])." !important;
		font-size: ".esc_html(intval(get_option('architek_blog_normal_title_size'), 10))."px !important;
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_blog_normal_title_color")))."
	}
	
	
	.blog-default-bg-masonry .the_title h2 a,
	.des_recent_posts_widget.widget .title h4,
	.related_posts_listing .related_post .title{";
		$font = get_option('architek_blog_masonry_title_font'); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; if (!isset($font[1])) $font[1] = "";
		$architek_style_data .= "
		font-family: '".wp_kses($font[0], 'post')."';
		font-weight: ".esc_html($font[1])." !important;
		font-size: ".esc_html(intval(get_option('architek_blog_masonry_title_size'), 10))."px !important;
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_blog_masonry_title_color")))."
	}
	
	.page_content .vc_column-inner a:not(.blog-read-more):not(.add_to_cart_button):hover:not(.woocommerce-LoopProduct-link):hover:not(.vc_btn3):not(.ult_price_action_button):not(.cbp-l-caption-buttonLeft):not(.cbp-l-caption-buttonRight):hover, header a:hover, #big_footer a:not(.submit):hover, .page-template-blog-masonry-template .posts_category_filter li:active,.page-template-blog-masonry-template .posts_category_filter li:focus, .page-template-blog-masonry-grid-template .posts_category_filter li:active,.page-template-blog-masonry-grid-template .posts_category_filter li:focus, .master_container a:active, .master_container .vc_column-inner a:not(.vc_btn3):not(.blog-read-more):not(.cbp-l-caption-buttonLeft):not(.cbp-l-caption-buttonRight):hover:not(.title):hover:not(.add_to_cart_button):hover:not(.woocommerce-LoopProduct-link):hover{
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_links_color_hover")))." !important;
		background-color: ".esc_html( (is_array(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_links_bg_color_hover"))) || get_option("architek_links_bg_color_hover") == "") ? "unset" : "#".str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_links_bg_color_hover")) ).";
	}
	#big_footer a:not(.submit):not(.tag-cloud-link):not(.social-network):hover{
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_footerbg_linkscolor_hover")))." !important;
	}
	.ult_tabmenu.style2 li.ult_tab_li a:hover{
		color: #fff !important;
	}
	.single_about_author a:hover{ color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_links_color_hover")))." !important; }
	
	h1{";
		$font = get_option('architek_h1_font'); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; if (!isset($font[1])) $font[1] = "";
		$architek_style_data .= "
		font-family: '".wp_kses($font[0], 'post')."';
		font-weight: ".esc_html($font[1]).";
		font-size: ".esc_html(intval(get_option('architek_h1_size'), 10))."px;
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_h1_color"))).";
	}
	
	h2{";
		$font = get_option('architek_h2_font'); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; if (!isset($font[1])) $font[1] = "";
		$architek_style_data .= "
		font-family: '".wp_kses($font[0], 'post')."';
		font-weight: ".esc_html($font[1]).";
		font-size: ".esc_html(intval(get_option('architek_h2_size'), 10))."px;
		color: #".esc_html(get_option('architek_h2_color')).";
	}
	
	h3{";
		$font = get_option('architek_h3_font'); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; if (!isset($font[1])) $font[1] = "";
		$architek_style_data .= "
		font-family: '".wp_kses($font[0], 'post')."';
		font-weight: ".esc_html($font[1]).";
		font-size: ".esc_html(intval(get_option('architek_h3_size'), 10))."px;
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_h3_color"))).";
	}
	
	h4{";
		$font = get_option('architek_h4_font'); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; if (!isset($font[1])) $font[1] = "";
		$architek_style_data .= "
		font-family: '".wp_kses($font[0], 'post')."';
		font-weight: ".esc_html($font[1]).";
		font-size: ".esc_html(intval(get_option('architek_h4_size'), 10))."px;
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_h4_color"))).";
	}
	
	.ult-item-wrap .title h4{font-size: 16px !important;}
	.wpb_content_element .wpb_accordion_header.ui-accordion-header-active a{color: ".esc_html($architek_styleColor).";}
	h5{";
		$font = get_option('architek_h5_font'); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; if (!isset($font[1])) $font[1] = "";
		$architek_style_data .= "
		font-family: '".wp_kses($font[0], 'post')."';
		font-weight: ".esc_html($font[1]).";
		font-size: ".esc_html(intval(get_option('architek_h5_size'), 10))."px;
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_h5_color"))).";
	}
	
	h6{";
		$font = get_option('architek_h6_font'); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; if (!isset($font[1])) $font[1] = "";
		$architek_style_data .= "
		font-family: '".wp_kses($font[0], 'post')."';
		font-weight: ".esc_html($font[1]).";
		font-size: ".esc_html(intval(get_option('architek_h6_size'), 10))."px;
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_h6_color"))).";
	}
		
	header.navbar, .header_style9_left_container{";
		if (is_singular() && get_post_meta($architek_theid, 'architek_enable_custom_header_options_value', true) == 'yes' && get_post_meta($architek_theid, 'architek_custom_header_pre_transparent_value', true) == "on"){
			// alterou se para levar a cor a ser aplicada no novo header type2 - leva na mma a opacidade a 0
			$color = architek_hex2rgb( str_replace( "__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_headerbg_color_".$architek_header_bgstyle_pre) ));
			$architek_style_data .= " background-color: rgba(".esc_html($color[0].",".$color[1].",".$color[2]).",0); ";
		} else {
			switch (get_option('architek_headerbg_type_'.$architek_header_bgstyle_pre)){
				case "color":
					$color = architek_hex2rgb( str_replace( "__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_headerbg_color_".$architek_header_bgstyle_pre) ));
					$architek_style_data .= "background-color: rgba(".esc_html($color[0].",".$color[1].",".$color[2].",".intval(str_replace("%","",get_option("architek_headerbg_opacity_".$architek_header_bgstyle_pre)))/100).");";
				break;
				case "image":
					$architek_style_data .= "background-repeat:no-repeat; background-position:center center; -o-background-size: cover !important; -moz-background-size: cover !important; -webkit-background-size: cover !important; background-size: cover !important;";
					$architek_style_data .= "background: url(" . esc_url(get_option("architek_headerbg_image_".$architek_header_bgstyle_pre)) . ") no-repeat fixed !important; background-size: cover !important;";  
				break;
				case "pattern":
					$architek_style_data .= "background: url('" . esc_url(get_template_directory_uri()) . "/images/architek_patterns/" . get_option("architek_headerbg_pattern_".$architek_header_bgstyle_pre) . "') 0 0 repeat !important;";
				break;
				case "custom_pattern":
					$architek_style_data .= "background: url('" . esc_url(get_option("architek_headerbg_custom_pattern_".$architek_header_bgstyle_pre)) . "') 0 0 repeat !important;";
				break;
			}
		}
	$architek_style_data .= "
	}
	
	header.header_with_after_scroll_t2.header_force_opacity{";  
		$color = architek_hex2rgb( str_replace( "__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_headerbg_color_".$architek_header_bgstyle_pre) ));
			$architek_style_data .= " background-color: rgba(".esc_html($color[0].",".$color[1].",".$color[2]).",1); ";
	$architek_style_data .= "}";
	
	if (get_option('architek_body_type','body_wide') == 'body_boxed' && get_option('architek_header_style_type') != 'style9'){
		$architek_style_data .= "body#boxed_layout, .header_style8_contents_bearer .navbar-collapse:after{";
		switch (get_option("architek_global_bg_type",'color')){
			case "image":
				$architek_style_data .= "background-repeat:no-repeat; background-position:center center; -o-background-size: cover !important; -moz-background-size: cover !important; -webkit-background-size: cover !important; background-size: cover !important;width: 100%;height: 100%;
	background-attachment: fixed !important;";
				$architek_style_data .= "background: url(" . esc_url(get_option("architek_global_bg_type_image")) . ") no-repeat;";  
			break;
			case "color":
	 			$architek_style_data .= "background-color: #" . esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_global_bg_type_color"))) . ";";
			break;
			case "pattern":
				$architek_style_data .= "background: url('" . esc_url(get_template_directory_uri()) . "/images/architek_patterns/" . get_option("architek_global_bg_type_pattern") . "') 0 0 repeat !important;";
			break;
			case "custom_pattern":
				$architek_style_data .= "background: url('" . esc_url(get_option("architek_global_bg_type_custom_pattern")) . "') 0 0 repeat !important;";
			break;
		}
		$architek_style_data .= "}
		body .boxed_layout .header_style8_right > *:not(#big_footer), .related_posts_listing .related_post .related_post_bg, .master_container, .blog-default,
		.page-template-blog-template .post-listing .vc_col-sm-4 .wpb_wrapper, .archive .post-listing .vc_col-sm-4 .wpb_wrapper, .blog-normal-with-sidebar .post-listing .vc_col-sm-12:last-child .wpb_wrapper, .cbp-popup-singlePageInline .cbp-popup-content > div, .cbp-lazyload{ background-color: #" . esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_bodybg_type_color"))) . "; }
		";
	} else {
		$architek_style_data .= "body, #main, .master_container, .related_posts_listing .related_post .related_post_bg, .blog-default, .header_style8_contents_bearer .navbar-collapse:after, .header_style9_contents_bearer .navbar-collapse:after, .cbp-popup-singlePageInline .cbp-popup-content > div, .cbp-lazyload, .blog-normal-with-sidebar .post-listing .vc_col-sm-12:last-child .wpb_wrapper, .page-template-blog-template .post-listing .vc_col-sm-4 .wpb_wrapper, .archive .post-listing .vc_col-sm-4 .wpb_wrapper{ background-color: #" . esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_global_bg_type_color"))) . " !important; }
			section.page_content { background-color: #" . esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_global_bg_type_color"))) . "; }
		";
		/* specifics for the original architek style layout */
		if (get_option('architek_header_style_type') == 'style8'){
			$architek_style_data .= "
				section.page_content > .container, .blog-default > .container, #primary_footer > .container, #secondary_footer > .container{ width: 100%; }
			";
		}
	}
	
	/* new header style8 */
	$architek_header_style = get_option('architek_header_style_type');
	if ($architek_header_style == 'style8' || $architek_header_style == 'style9'){
		$architek_style_data .= "
			.header_".esc_attr($architek_header_style)."_left .nav > li > a{
				padding-top: ".esc_html(intval(get_option('architek_menu_margin_top_pre_'.$architek_header_style_pre),10))."px;
				padding-bottom: ".esc_html(intval(get_option('architek_menu_padding_bottom_pre_'.$architek_header_style_pre),10))."px;
				padding-left:".esc_html(intval(get_option('architek_menu_side_margin_pre_'.$architek_header_style_pre),10))."px;
			}
			.header_".esc_attr($architek_header_style)."_left .nav > li:hover > a, .header_".esc_attr($architek_header_style)."_left .nav li > a:hover, .header_".esc_attr($architek_header_style)."_left .nav > li.current-menu-item > a, .header_".esc_attr($architek_header_style)."_left .nav > li.current-menu-ancestor > a{";
				$color = architek_hex2rgb(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_sub_menu_bg_color_hover")));
				$architek_style_data .= "background-color: rgba(".esc_html($color[0].",".$color[1].",".$color[2].",".intval(str_replace("%","",get_option("architek_sub_menu_bg_color_hover_opacity")))/100).") !important;
			}
			.header_".esc_attr($architek_header_style)."_left_container .nav > li ul{";
				$color = architek_hex2rgb(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_sub_menu_bg_color")));
				$architek_style_data .= "background-color: rgba(".esc_html($color[0].",".$color[1].",".$color[2].",".intval(str_replace("%","",get_option("architek_sub_menu_bg_opacity")))/100).") !important;
			}
			.header_".esc_attr($architek_header_style)."_left_container .navbar-collapse .nav li.menu-item-has-children:hover > ul.dropdown-menu{";
				$color = architek_hex2rgb(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_sub_menu_bg_color")));
				$architek_style_data .= "border: none rgba(".esc_html($color[0].",".$color[1].",".$color[2].",".intval(str_replace("%","",get_option("architek_sub_menu_bg_opacity")))/100).") !important;
			}
			"; 
	}
	
	/* new header style9 */
	if ($architek_header_style == 'style9'){
		$architek_style_data .= "
			header > .architek_style9_social_icons a, header > .architek_style9_social_icons span, .header_style9_contents_bearer .architek_right_header_icons > *{ color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_header_icons_color_".$architek_header_style_pre))).";}
			.header_style9_contents_bearer.architek_menu_trigger .hamburguer-trigger-menu-icon{ background-color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_header_icons_color_".$architek_header_style_pre)))." !important; }
			header > .architek_style9_social_icons a:hover, header .architek_right_header_icons > *:hover{ color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_header_icons_hover_color_".$architek_header_style_pre))).";}
			header > .architek_style9_footer_contents .footer_custom_text *{";
				$font = get_option('architek_footer_custom_text_font'); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; if (!isset($font[1])) $font[1] = "";
				$architek_style_data .= "
				font-family: '".wp_kses($font[0], 'post')."';
				font-weight: ".esc_html($font[1]).";
				font-size: ".esc_html(intval(get_option('architek_footer_custom_text_font_size'),10))."px;
				color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option('architek_footer_custom_text_font_color'))).";
			}
			header .architek-opened-footer-elements .architek_style9_footer_contents .footer_custom_text *{";
				$font = get_option('architek_footer_custom_text_font_opened'); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; if (!isset($font[1])) $font[1] = "";
				$architek_style_data .= "
				font-family: '".wp_kses($font[0], 'post')."';
				font-weight: ".esc_html($font[1]).";
				font-size: ".esc_html(intval(get_option('architek_footer_custom_text_font_size_opened'),10))."px;
				color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option('architek_footer_custom_text_font_color_opened'))).";
			}
			header .architek-opened-footer-elements .architek_style9_social_icons a, header .architek-opened-footer-elements .architek_style9_social_icons span, .header_style9_contents_bearer.menu-opened .architek_right_header_icons > *{ color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_header_after_scroll_icons_color_".$architek_header_style_after))).";}
			.header_style9_contents_bearer.architek_menu_trigger.menu-opened .hamburguer-trigger-menu-icon{ background-color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_header_after_scroll_icons_color_".$architek_header_style_after)))." !important; }
			header .architek-opened-footer-elements .architek_style9_social_icons a:hover, .header_style9_contents_bearer.menu-opened .architek_right_header_icons *:hover{ color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_header_after_scroll_icons_hover_color_".$architek_header_style_after))).";}
			
			.header_style9_contents_bearer.menu-opened .navbar-header{ height: ". esc_html(intval(get_option('architek_logo_reduced_height'),10))."px; }
			.header_style9_contents_bearer.menu-opened a.navbar-brand img.logo_after_scroll{ max-height: ". esc_html(intval(get_option('architek_logo_reduced_height'),10))."px; }
			
		";
		if ($architek_header_style_pre != $architek_header_style_after){
			$architek_style_data .= "
				.header_style9_contents_bearer.menu-opened header{";
					switch (get_option('architek_headerbg_after_scroll_type_'.$architek_header_style_after)){
						case "color":
							$color = architek_hex2rgb( str_replace( "__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_headerbg_after_scroll_color_".$architek_header_style_after) ));
							$architek_style_data .= "background-color: rgba(".esc_html($color[0].",".$color[1].",".$color[2].",".intval(str_replace("%","",get_option("architek_headerbg_opacity_".$architek_header_style_after)))/100).");";
						break;
						case "image":
							$architek_style_data .= "background-repeat:no-repeat; background-position:center center; -o-background-size: cover !important; -moz-background-size: cover !important; -webkit-background-size: cover !important; background-size: cover !important;";
							$architek_style_data .= "background: url(" . esc_url(get_option("architek_headerbg_after_scroll_image_".$architek_header_style_after)) . ") no-repeat fixed !important; background-size: cover !important;";  
						break;
						case "pattern":
							$architek_style_data .= "background: url('" . esc_url(get_template_directory_uri()) . "/images/architek_patterns/" . get_option("architek_headerbg_after_scroll_pattern_".$architek_header_style_after) . "') 0 0 repeat !important;";
						break;
						case "custom_pattern":
							$architek_style_data .= "background: url('" . esc_url(get_option("architek_headerbg_after_scroll_custom_pattern_".$architek_header_style_after)) . "') 0 0 repeat !important;";
						break;
					}
			$architek_style_data .= " 
				}";
		}
	} else {
		/* new footer custom text options - except style9 */
		$architek_style_data .= "
			.footer_custom_text *{";
				$font = get_option('architek_footer_custom_text_font'); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; if (!isset($font[1])) $font[1] = "";
				$architek_style_data .= "
				font-family: '".wp_kses($font[0], 'post')." !important';
				font-weight: ".esc_html($font[1] ? $font[1] : "inherit")." !important;
				font-size: ".esc_html(intval(get_option('architek_footer_custom_text_font_size'),10))."px !important;
				color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option('architek_footer_custom_text_font_color', '000')))." !important;
			}
		";
	}
	
	$architek_style_data .= "
	header .header_style2_contact_info{";
		if (get_option("architek_logo_margin_top")) 
			$architek_style_data .= "margin-top: " . str_replace(" ", "", get_option("architek_logo_margin_top")) . " !important;margin-bottom: " . str_replace(" ", "", get_option("architek_logo_margin_top")) . " !important;
	}

	
	header .navbar-header, header.style4 .nav-container .navbar-header .navbar-brand{";
		if (get_option("architek_logo_margin_top")) 
			$architek_style_data .= "margin-top: " . str_replace(" ", "", get_option("architek_logo_margin_top")) . ";margin-bottom: " . str_replace(" ", "", get_option("architek_logo_margin_top")) . ";"; 
		if (get_option("architek_logo_margin_left")) $architek_style_data .= "margin-left: " . str_replace(" ", "", get_option("architek_logo_margin_left")) . ";"; 
		if (get_option("architek_logo_height")) $architek_style_data .= "height:" . get_option("architek_logo_height") . ";";
	$architek_style_data .= "
	}
	
	header a.navbar-brand img{max-height: ".esc_html(intval(get_option('architek_logo_height'),10))."px;}";
			
	$header_after_scroll = false;
	if (get_option('architek_fixed_menu') == 'on'){
		if (get_option('architek_header_after_scroll') == 'on'){
			$header_after_scroll = true;
			$architek_style_data .= "
			header.navbar.header_after_scroll, header.header_after_scroll .navbar-nav > li.architek_mega_menu > .dropdown-menu, header.header_after_scroll .navbar-nav > li:not(.architek_mega_menu) .dropdown-menu{";
				switch (get_option('architek_headerbg_after_scroll_type_'.$architek_header_bgstyle_after)){
					case "color":
						$color = architek_hex2rgb( str_replace( "__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_headerbg_after_scroll_color_".$architek_header_bgstyle_after) ));
						$architek_style_data .= "background-color: rgba(".esc_html($color[0].",".$color[1].",".$color[2].",".intval(str_replace("%","",get_option("architek_headerbg_after_scroll_opacity_".$architek_header_bgstyle_after)))/100).")";
					break;
					case "image":
						$architek_style_data .= "background-repeat:no-repeat; background-position:center center; -o-background-size: cover !important; -moz-background-size: cover !important; -webkit-background-size: cover !important; background-size: cover !important;";
						$architek_style_data .= "background: url(" . esc_url(get_option("architek_headerbg_after_scroll_image_".$architek_header_bgstyle_after)) . ") no-repeat fixed !important; background-size: cover !important;";  
					break;
					case "pattern":
						$architek_style_data .= "background: url('" . esc_url(get_template_directory_uri()) . "/images/architek_patterns/" . get_option("architek_headerbg_after_scroll_pattern_".$architek_header_bgstyle_after) . "') 0 0 repeat !important;";
					break;
					case "custom_pattern":
						$architek_style_data .= "background: url('" . esc_url(get_option("architek_headerbg_after_scroll_custom_pattern_".$architek_header_bgstyle_after)) . "') 0 0 repeat !important;";
					break;
				}
			$architek_style_data .= "
			}
			";
			$header_shrink = false;
			if (get_option('architek_fixed_menu') == 'on'){
				if (get_option('architek_header_after_scroll') == 'on'){
					if (get_option('architek_header_shrink_effect') == 'on'){
						$header_shrink = true;
						$architek_style_data .= "header.header_after_scroll a.navbar-brand img.logo_after_scroll{max-height: ". esc_html(intval(get_option('architek_logo_reduced_height'),10))."px;}";
					}
				}
			}
			
			$architek_style_data .= "
			header.header_after_scroll .navbar-collapse ul.menu-depth-1 li:not(.architek_mega_hide_link) a, header.header_after_scroll .dl-menuwrapper li:not(.architek_mega_hide_link) a, header.header_after_scroll .gosubmenu {
				color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option('architek_sub_menu_color'))).";
			}
			header.header_after_scroll .dl-back{color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option('architek_sub_menu_color'))).";}
			
			header.header_after_scroll .navbar-collapse ul.menu-depth-1 li:not(.architek_mega_hide_link):hover > a, header.header_after_scroll .dl-menuwrapper li:not(.architek_mega_hide_link):hover > a, header.header_after_scroll .dl-menuwrapper li:not(.architek_mega_hide_link):hover > a, header.header_after_scroll .dl-menuwrapper li:not(.architek_mega_hide_link):hover > header.header_after_scroll .gosubmenu, header.header_after_scroll .dl-menuwrapper li.dl-back:hover, header.header_after_scroll.navbar .nav-container .dropdown-menu li:hover{
				color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option('architek_sub_menu_color_hover')))." !important;
			}
			
			
			header #dl-menu ul,
			header.header_after_scroll #dl-menu ul{";
				$color = architek_hex2rgb(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_sub_menu_bg_color")));
				$architek_style_data .= "background-color: rgba(".esc_html($color[0].",".$color[1].",".$color[2].",".intval(str_replace("%","",get_option("architek_sub_menu_bg_opacity")))/100).") !important;
			}
			
			header.header_after_scroll .navbar-collapse .architek_mega_menu ul.menu-depth-2, header.header_after_scroll .navbar-collapse .architek_mega_menu ul.menu-depth-2 ul {background-color: transparent !important;} 
			
			header li:not(.architek_mega_menu) ul.menu-depth-1 li:hover, header li.architek_mega_menu li.menu-item-depth-1 li:hover, header #dl-menu ul li:hover
			,header.header_after_scroll li:not(.architek_mega_menu) ul.menu-depth-1 li:hover, header.header_after_scroll li.architek_mega_menu li.menu-item-depth-1 li:hover, header.header_after_scroll #dl-menu ul li:hover{";
				$color = architek_hex2rgb(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_sub_menu_bg_color_hover")));
				$architek_style_data .= "background-color: rgba(".esc_html($color[0].",".$color[1].",".$color[2].",".intval(str_replace("%","",get_option("architek_sub_menu_bg_color_hover_opacity")))/100).") !important;
			}

			header.header_after_scroll .navbar-collapse li:not(.architek_mega_menu) ul.menu-depth-1 li:not(:first-child){";
				$color = architek_hex2rgb(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_sub_menu_border_color")));
				$architek_style_data .= "border-top: 1px solid rgba(".esc_html($color[0].",".$color[1].",".$color[2].",".intval(str_replace("%","",get_option("architek_sub_menu_border_color_opacity")))/100).") !important;
			}
			header.header_after_scroll .navbar-collapse li.architek_mega_menu ul.menu-depth-2{";
				$color = architek_hex2rgb(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_sub_menu_border_color")));
				$architek_style_data .= "border-right: 1px solid rgba(".esc_html($color[0].",".$color[1].",".$color[2].",".intval(str_replace("%","",get_option("architek_sub_menu_border_color_opacity")))/100).") !important;
			}
			header.header_after_scroll #dl-menu li:not(:last-child) a, header.header_after_scroll #dl-menu ul li:not(:last-child) a{";
				$color = architek_hex2rgb(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_sub_menu_border_color")));
				$architek_style_data .= "border-bottom: 1px solid rgba(".esc_html($color[0].",".$color[1].",".$color[2].",".intval(str_replace("%","",get_option("architek_sub_menu_border_color_opacity")))/100).") !important;
			}
			
			.header_after_scroll .navbar-collapse ul.navbar-nav > li > a, .header_after_scroll .navbar-collapse > .header_style2_menu > ul > li > a{";
				$font = get_option('architek_menu_font_after_'.$architek_header_style_after); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; if (!isset($font[1])) $font[1] = "";
				$architek_style_data .= "
				font-family: '".wp_kses($font[0], 'post')."';
				font-weight: ".esc_html($font[1]).";
				font-size: ".esc_html(intval(get_option('architek_menu_font_size_after_'.$architek_header_style_after),10))."px;
				color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option('architek_menu_color_after_'.$architek_header_style_after))).";";
				if (get_option('architek_menu_uppercase_after_'.$architek_header_style_after) === 'on') $architek_style_data .= "text-transform: uppercase;\n"; else $architek_style_data .= "text-transform:none;\n";
				$architek_style_data .= "letter-spacing: ".esc_html(intval(get_option('architek_menu_letter_spacing_after_'.$architek_header_style_after),10))."px;
			}
			
			.header_after_scroll .navbar-collapse > .header_style2_menu > ul > li > a:hover,
			.header_after_scroll .navbar-collapse > .header_style2_menu > ul > li.current-menu-ancestor > a,
			.header_after_scroll .navbar-collapse > .header_style2_menu > ul > li.current-menu-item > a,
			.header_after_scroll .navbar-collapse > .header_style2_menu > ul > li > a.selected,
			.header_after_scroll .navbar-collapse > .header_style2_menu > ul > li > a.hover_selected,
			.header_after_scroll .navbar-collapse ul.navbar-nav > li > a:hover,
			.header_after_scroll .navbar-collapse ul.navbar-nav > li.current-menu-ancestor > a,
			.header_after_scroll .navbar-collapse ul.navbar-nav > li.current-menu-item > a,
			.header_after_scroll .navbar-collapse ul.navbar-nav > li > a.selected, .header_after_scroll .navbar-collapse ul.navbar-nav > li > a.hover_selected{
				color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option('architek_menu_color_hover_after_'.$architek_header_style_after)))." !important;
			}
			
			.header_after_scroll .dl-menuwrapper button:after{
				background: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option('architek_menu_color_hover_after_'.$architek_header_style_after))).";
				box-shadow: 0 6px 0 #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option('architek_menu_color_hover_after_'.$architek_header_style_after))).", 0 12px 0 #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option('architek_menu_color_hover_after_'.$architek_header_style_after))).";
			}
			header.light .dl-menuwrapper button:after,
			header.header_after_scroll.light .dl-menuwrapper button:after{
				background: #101010;
				box-shadow: 0 6px 0 #101010, 0 12px 0 #101010;
			}
			header.dark .dl-menuwrapper button:after,
			header.header_after_scroll.dark .dl-menuwrapper button:after{
				background: #fff;
				box-shadow: 0 6px 0 #fff, 0 12px 0 #fff;
			}
			";
			
			if (get_option('architek_menu_add_border_after_'.$architek_header_style_after) == "on"){
				$architek_style_data .= ".header_after_scroll .navbar-collapse ul.menu-depth-1, .header_after_scroll .nav-container .architek_minicart{padding-top:3px !important;border-top:3px solid #".str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option('architek_menu_border_color_after_'.$architek_header_style_after))." !important;}";
			}
			$architek_style_data .= "
			";
			
			$header_shrink = false;
			if (get_option('architek_fixed_menu') == 'on'){
				if (get_option('architek_header_after_scroll') == 'on'){
					if (get_option('architek_header_shrink_effect') == 'on'){
						$header_shrink = true;
						$architek_style_data .= "
						header.header_after_scroll.navbar-default .navbar-nav > li > a,
						header.headerclone.navbar-default .navbar-nav > li > a {
							padding-top:".esc_html(intval(get_option('architek_menu_margin_top_after_'.$architek_header_style_after),10))."px;
							padding-bottom:".esc_html(intval(get_option('architek_menu_padding_bottom_after_'.$architek_header_style_after),10))."px;
							 /*margin-bottom:".esc_html(intval(get_option('architek_menu_padding_bottom_after_'.$architek_header_style_after),10))."px;*/
							 margin-bottom: 0px;
						}
						
						header.header_after_scroll.navbar-default .navbar-nav > li,
						header.headerclone.navbar-default .navbar-nav > li{
							padding-right:".esc_html(intval(get_option('architek_menu_side_margin_after_'.$architek_header_style_after),10))."px;
							padding-left:".esc_html(intval(get_option('architek_menu_side_margin_after_'.$architek_header_style_after),10))."px;
							 margin-bottom: 0px;
						}
					
						header.header_after_scroll .architek-header-button{margin-top:".esc_html(intval(get_option('architek_menu_margin_top_after_'.$architek_header_style_after),10))."px;}
						
						header.header_after_scroll.style2 .navbar-nav > li, .navbar-default.menu-square.style2 .navbar-nav > li {padding-top:0px;}
						header.header_after_scroll.style2{
							padding-bottom:".esc_html(intval(get_option('architek_menu_margin_top_pre_'.$architek_header_style_after),10))."px;
						}
						header.header_after_scroll.style2 .header_style2_menu{
							margin-top:".esc_html(intval(get_option('architek_menu_margin_top_pre_'.$architek_header_style_after),10))."px !important;
						}
						
						
						header.header_after_scroll.style5 .architek_right_header_icons,
						header.header_after_scroll.style1 .architek_right_header_icons,
						header.header_after_scroll.style2 .architek_right_header_icons,
						header.header_after_scroll.style4 .architek_right_header_icons,
						header.header_after_scroll.style6 .architek_right_header_icons,
						header.header_after_scroll.style7 .architek_right_header_icons{
							padding-top:".esc_html(intval(get_option('architek_menu_margin_top_after_'.$architek_header_style_after),10))."px;
							padding-bottom:".esc_html(intval(get_option('architek_menu_padding_bottom_after_'.$architek_header_style_after),10))."px;
						}

						header.header_after_scroll .navbar-nav > li > ul{
							margin-top:0px !important;
						}
					
						header.header_after_scroll .architek_minicart_wrapper{
							padding-top:".esc_html(intval(get_option('architek_menu_padding_bottom_after_'.$architek_header_style_after),10))."px;
						}
						";
					}
				}
			}
		}
	}
		
		
	$header_shrink = false;
	if (get_option('architek_fixed_menu') == 'on'){
		if (get_option('architek_header_after_scroll') == 'on'){
			if (get_option('architek_header_shrink_effect') == 'on'){
				$header_shrink = true;
				$architek_style_data .= "
				header.header_after_scroll .header_style2_contact_info{";
					if (get_option("architek_logo_after_scroll_margin_top")) $architek_style_data .= "margin-top: " . str_replace(" ", "", get_option("architek_logo_after_scroll_margin_top")) . " !important;margin-bottom: " . str_replace(" ", "", get_option("architek_logo_after_scroll_margin_top")) . " !important;
				}
				header.header_after_scroll .navbar-header, header.style4.header_after_scroll .nav-container .navbar-header .navbar-brand, header.headerclone.header_after_scroll .navbar-header{";
					if (get_option("architek_logo_after_scroll_margin_top")) $architek_style_data .= "margin-top: " . str_replace(" ", "", get_option("architek_logo_after_scroll_margin_top")) . ";margin-bottom: " . str_replace(" ", "", get_option("architek_logo_after_scroll_margin_top")) . ";"; 
					if (get_option("architek_logo_after_scroll_margin_left")) $architek_style_data .= "margin-left: " . str_replace(" ", "", get_option("architek_logo_after_scroll_margin_left")) . ";"; 
					if (get_option("architek_logo_reduced_height")) $architek_style_data .= "height:" . get_option("architek_logo_reduced_height") . ";"; 
					else {
						if (get_option("architek_logo_height")) $architek_style_data .= "height:" . get_option("architek_logo_height") . ";";
					}
				$architek_style_data .= "
				}

				";
			}
		}
	}
	
	if (get_option("architek_info_above_menu") == "on"){
		$color = architek_hex2rgb( str_replace( "__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_topbar_bg_color") ));
		$architek_style_data .= "
		header .top-bar .top-bar-bg, header .top-bar #lang_sel a.lang_sel_sel, header .top-bar #lang_sel > ul > li > ul > li > a{
			background-color: rgba(".esc_html($color[0].",".$color[1].",".$color[2].",".intval(str_replace("%","",get_option("architek_topbar_bg_opacity")))/100).");
		}
		header .top-bar ul.phone-mail li, header .top-bar ul.phone-mail li i{
			color: #".esc_html( str_replace( "__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_topbar_text_color") )).";
		}
		header .top-bar a, header .top-bar ul.phone-mail li a{
			color: #".esc_html( str_replace( "__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_topbar_links_color") ))." !important;
		}
		header .top-bar a:hover, header .top-bar ul.phone-mail li a:hover{
			color: #".esc_html( str_replace( "__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_topbar_links_hover_color") ))." !important;
		}
		header .top-bar .social-icons-fa li a,
		header.style3 .search_trigger .icon
		{
			color: #".esc_html( str_replace( "__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_topbar_social_color") ))." !important;
		}
		header .top-bar .social-icons-fa li a:hover,
		header.style3 .search_trigger .icon:hover,
		header.style4 .architek_dynamic_shopping_bag .dripicons-cart:hover,
		header.style4 .search_trigger .dripicons-search:hover{
			color: #".esc_html( str_replace( "__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_topbar_social_hover_color") ))." !important;
		}
		header .top-bar *{
			border-color: #".esc_html( str_replace( "__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_topbar_borders_color") ))." !important;
		}
		header .top-bar .down-button{
			border-color: transparent rgba(".esc_html($color[0].",".$color[1].",".$color[2].",".intval(str_replace("%","",get_option("architek_topbar_bg_opacity")))/100).") transparent transparent !important;
		}
		header .top-bar.opened .down-button{
			border-color: transparent #fff transparent transparent !important;
		}
		";
	}
	$architek_style_data .= "
	#primary_footer > .container, #primary_footer > .no-fcontainer{
		padding-top:".esc_html(intval(get_option('architek_primary_footer_padding_top'),10))."px;
		padding-bottom:".esc_html(intval(get_option('architek_primary_footer_padding_bottom'),10))."px;
	}
	/* #primary_footer */#big_footer{";
		switch (get_option("architek_footerbg_type")){
			case "image":
				$architek_style_data .= "background-repeat:no-repeat; background-position:center center; -o-background-size: cover !important; -moz-background-size: cover !important; -webkit-background-size: cover !important; background-size: cover !important;";
				$architek_style_data .= "background: url(" . esc_url(get_option("architek_footerbg_image")) . ") no-repeat; background-size: cover !important;";  
			break;
			case "color":
				$color = architek_hex2rgb(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_footerbg_color")));
				$architek_style_data .= "background-color: rgba(".esc_html($color[0].",".$color[1].",".$color[2].",".intval(str_replace("%","",get_option("architek_footerbg_color_opacity")))/100).");";
			break;
			case "pattern":
				$architek_style_data .= "background: url('" . esc_url(get_template_directory_uri()) . "/images/architek_patterns/" . esc_html(get_option("architek_footerbg_pattern")) . "') 0 0 repeat !important;";
			break;
			case "custom_pattern":
				$architek_style_data .= "background: url('" . esc_url(get_option("architek_footerbg_custom_pattern")) . "') 0 0 repeat !important;";
			break;
		}
	$architek_style_data .= "
	}
	
	#primary_footer input, 
	#primary_footer textarea{";
		switch (get_option("architek_footerbg_type")){
			case "image": case "pattern": case "custom_pattern":
				$architek_style_data .= "background: transparent;";  
			break;
			case "color":
				$color = architek_hex2rgb(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_footerbg_color")));
				$architek_style_data .= "background-color: rgba(".esc_html($color[0].",".$color[1].",".$color[2].",".intval(str_replace("%","",get_option("architek_footerbg_color_opacity")))/100).");";
			break;
		}
	$architek_style_data .= "
	}
	header.header_not_fixed ul.menu-depth-1,
	header.header_not_fixed ul.menu-depth-1 ul,
	header.header_not_fixed ul.menu-depth-1 ul li,
	header.header_not_fixed #dl-menu ul{";
		$color = architek_hex2rgb(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_sub_menu_bg_color")));
		$architek_style_data .= "background-color: rgba(".esc_html($color[0].",".$color[1].",".$color[2].",".intval(str_replace("%","",get_option("architek_sub_menu_bg_opacity")))/100).") !important;
	}

	header.header_not_fixed li:not(.architek_mega_menu) ul.menu-depth-1 li:hover, header.header_not_fixed li.architek_mega_menu li.menu-item-depth-1 li:hover, header.header_not_fixed #dl-menu ul li:hover{";
		$color = architek_hex2rgb(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_sub_menu_bg_color_hover")));
		$architek_style_data .= "background-color: rgba(".esc_html($color[0].",".$color[1].",".$color[2].",".intval(str_replace("%","",get_option("architek_sub_menu_bg_color_hover_opacity")))/100).") !important;
	}
	
	
 	#primary_footer input:not(.button),#primary_footer textarea{
		border: 1px solid #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_footerbg_borderscolor")))." !important;
	}
	
	#big_footer .widget-newsletter input{
		background: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_footerbg_borderscolor")))." !important;
	}
	
	
	.footer_sidebar .contact-widget-container input,
	.footer_sidebar .contact-widget-container textarea{
		border: 1px solid #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_footerbg_borderscolor")))." !important;
	}
	html .widget_nav_menu .sub-menu li:last-child,
	html .menu .sub-menu li:last-child {
	    border-bottom: none !important;
	}
	.footer_sidebar table td, .footer_sidebar table th, .footer_sidebar .wp-caption{
		border: 1px solid #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_footerbg_borderscolor"))).";
	}
	#primary_footer a{
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_footerbg_linkscolor"))).";
	}
	
	#primary_footer, #primary_footer p, #big_footer input, #big_footer textarea,
	.widget-contact-info-content, #primary_footer .content-left-author span, #primary_footer .rssSummary,#primary_footer .rss-date, #primary_footer cite,
	#primary_footer li{
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_footerbg_paragraphscolor"))).";
	}
	
	#primary_footer .footer_sidebar > h4, #primary_footer .footer_sidebar > .widget > h4, #primary_footer .widget .widget-contact-content h4, #primary_footer .footer_sidebar > h4 a.rsswidget, #primary_footer .footer_sidebar h4.widget_title_span{
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_footerbg_headingscolor"))).";
	}
	
	#secondary_footer{";
		switch (get_option("architek_sec_footerbg_type")){
			case "image":
				$architek_style_data .= "background-repeat:no-repeat; background-position:center center; -o-background-size: cover !important; -moz-background-size: cover !important; -webkit-background-size: cover !important; background-size: cover !important;";
				$architek_style_data .= "background: url(" . esc_url(get_option("architek_sec_footerbg_image")) . ") no-repeat fixed !important; background-size: cover !important;";  
			break;
			case "color":
				$color = architek_hex2rgb(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_sec_footerbg_color")));
				$architek_style_data .= "background-color: rgba(".esc_html($color[0].",".$color[1].",".$color[2].",".intval(str_replace("%","",get_option("architek_sec_footerbg_color_opacity")))/100).");";
			break;
			case "pattern":
				$architek_style_data .= "background: url('" . esc_url(get_template_directory_uri()) . "/images/architek_patterns/" . esc_html(get_option("architek_sec_footerbg_pattern")) . "') 0 0 repeat !important;";
			break;
			case "custom_pattern":
				$architek_style_data .= "background: url('" . esc_url(get_option("architek_sec_footerbg_custom_pattern")) . "') 0 0 repeat !important;";
			break;
		}
		$architek_style_data .= "
		padding-top:".esc_html(intval(get_option('architek_secondary_footer_padding_top'),10))."px;
		padding-bottom:".esc_html(intval(get_option('architek_secondary_footer_padding_bottom'),10))."px;
	}";
	
	if (get_option("architek_show_sec_footer") == "on"){
		if (get_option("architek_footer_display_logo") == "on"){
			if (get_option('architek_footer_logo_type') == "text"){
				$architek_style_data .= "
				#secondary_footer .footer_logo .logo{";
					$font = get_option('architek_sec_footer_logo_font'); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; if (!isset($font[1])) $font[1] = "";
					$architek_style_data .= "
					font-family: '".wp_kses($font[0], 'post')."';
					font-weight: ".esc_html($font[1]).";
					font-size: ".esc_html(intval(get_option('architek_sec_footer_logo_font_size'), 10))."px;
					color: #".esc_html(get_option('architek_sec_footer_logo_font_color')).";
				}
				#secondary_footer .footer_logo .logo:hover{
					color: #".esc_html(get_option('architek_sec_footer_logo_font_hover_color')).";
				}";
			}
		}
	}
	$architek_style_data .= "
	
	#secondary_footer .social-icons-fa a i{
		font-size: ".esc_html(intval(get_option('architek_sec_footer_social_icons_size'),10))."px;
		line-height: ".esc_html(intval(get_option('architek_sec_footer_social_icons_size'),10))."px;
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_sec_footer_social_icons_color"))).";
	}
	#secondary_footer .social-icons-fa a i:before{
		font-size: ".esc_html(intval(get_option('architek_sec_footer_social_icons_size'),10))."px;
	}
	#secondary_footer .social-icons-fa a:hover i{
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_sec_footer_social_icons_hover_color"))).";
	}
	
	header.style2 .search_input{
		height: calc(100% + ".esc_html(intval(get_option('architek_menu_margin_top_pre_'.$architek_header_style_pre),10))."px);
	}
	
	body > .search_input{";
		$color = architek_hex2rgb(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_search_input_background_color")));
		$architek_style_data .= "background-color: rgba(".esc_html($color[0].",".$color[1].",".$color[2].",".intval(str_replace("%","",get_option("architek_search_input_background_opacity")))/100).");
	}
	body > .search_input input.search_input_value{";
		$font = get_option("architek_search_input_font"); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; 	if (!isset($font[1])) $font[1] = "";
		$architek_style_data .= "
		font-family: '".wp_kses($font[0], 'post')."';
		font-weight: ".esc_html($font[1]).";
	}
	body > .search_input input.search_input_value{
		font-size: ".esc_html(intval(get_option("architek_search_input_font_size"),10))."px;
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_search_input_font_color"))).";
	}
	body > .search_input .search_close, body > .search_input input.search_input_value::placeholder{
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_search_input_font_color"))).";
	}
	.architek_search_input .searchinput:after{
		background: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_search_input_underline_color"))).";
		margin-top: ". round( intval(get_option("architek_search_input_font_size"),10) * .75 ) ."px;
	}
	
	body > .search_input .ajax_search_results{
		margin-top: ".intval(get_option("architek_search_input_font_size"),10)."px;
	}
	
	body > .search_input input.search_input_value::-webkit-input-placeholder, body > .search_input input.search_input_value::-moz-placeholder, body > .search_input input.search_input_value:-ms-input-placeholder, body > .search_input input.search_input_value:-moz-placeholder, body > .search_input input.search_input_value::placeholder{
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_search_input_font_color"))).";
	}
	
	body > .search_input .ajax_search_results ul{";
		$color = architek_hex2rgb(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_search_result_background_color")));
		$architek_style_data .= "background-color: rgba(".esc_html($color[0].",".$color[1].",".$color[2].",".intval(str_replace("%","",get_option("architek_search_result_background_opacity")))/100).");
	}
	body > .search_input .ajax_search_results ul li.selected{";
		$color = architek_hex2rgb(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_search_selected_result_background_color")));
		$architek_style_data .= "background-color: rgba(".esc_html($color[0].",".$color[1].",".$color[2].",".intval(str_replace("%","",get_option("architek_search_result_background_opacity")))/100).");
	}
	body > .search_input .ajax_search_results ul li{
		border-bottom: 1px solid #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_search_result_borders"))).";
	}
	body > .search_input .ajax_search_results ul li a{";
		$font = get_option("architek_search_input_font"); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; 	if (!isset($font[1])) $font[1] = "";
		$architek_style_data .= "
		font-family: '".wp_kses($font[0], 'post')."';
		font-weight: ".esc_html($font[1]).";
		font-size: ".esc_html(intval(get_option("architek_search_result_font_size"),10))."px;
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_search_result_font_color")))."
	}
	body > .search_input .ajax_search_results ul li.selected a{
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_search_selected_result_font_color")))."
	}
	body > .search_input .ajax_search_results ul li a span, body > .search_input .ajax_search_results ul li a span i{";
		$font = get_option("architek_search_result_details_font"); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; if (!isset($font[1])) $font[1] = "";
		$architek_style_data .= "
		font-family: '".wp_kses($font[0], 'post')."';
		font-weight: ".esc_html($font[1] != "" ? $font[1] : "inherit").";
		font-size: ".esc_html(intval(get_option("architek_search_result_details_font_size"),10))."px;
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_search_result_details_font_color")))."
	}
	body > .search_input .ajax_search_results ul li.selected a span{
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_search_selected_result_details_font_color")))."
	}";
	
	
	$loader = ((is_page_template() && get_post_meta(get_the_ID(), 'architek_enable_custom_header_options_value', true) == "yes") || (is_single() && get_post_meta(get_the_ID(), 'architek_enable_custom_header_options_value', true) == "yes")) ? get_post_meta(get_the_ID(), 'architek_enable_website_loading_value', true) : get_option("architek_enable_website_loader");
	if ($loader == "on"){
		$architek_style_data .= "
		body #architek_website_load, #architek_website_load .load2 .loader:before, #architek_website_load .load2 .loader:after, #architek_website_load .load3 .loader:after{background: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_background"))).";}
		
		.ball-pulse>div, .ball-pulse-sync>div, .ball-scale>div, .ball-rotate>div, .ball-rotate>div:before, .ball-clip-rotate>div, .ball-clip-rotate-pulse>div:first-child, .ball-beat>div, .ball-scale-multiple>div, .ball-triangle-path>div, .ball-pulse-rise>div, .ball-grid-beat>div, .ball-grid-pulse>div, .ball-spin-fade-loader>div, .ball-zig-zag>div, .ball-zig-zag-deflect>div, .line-scale>div, .line-scale-party>div, .line-scale-pulse-out>div, .line-scale-pulse-out-rapid>div, .line-spin-fade-loader>div, .square-spin>div, .pacman>div:nth-child(3),.pacman>div:nth-child(4),.pacman>div:nth-child(5),.pacman>div:nth-child(6), .cube-transition>div, .ball-rotate>div:after, .ball-rotate>div:before, #architek_website_load .load3 .loader:before, #architek_website_load .load3 .loader:before{background-color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).";}

		.ball-clip-rotate>div{border-top-color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).";border-left-color: #". esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).";border-right-color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).";}

		.ball-clip-rotate-pulse>div:last-child, .ball-clip-rotate-multiple>div:last-child{border-top-color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).";border-bottom-color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).";}
		
		.ball-clip-rotate-multiple>div{border-right-color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).";border-left-color:#". esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).";}

		.ball-triangle-path>div, .ball-scale-ripple>div, .ball-scale-ripple-multiple>div{border-color:#".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).";}
		
		.pacman>div:first-of-type, .pacman>div:nth-child(2){border-top-color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).";border-left-color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).";border-bottom-color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).";}
		
		.load2 .loader{box-shadow:inset 0 0 0 1em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).";}";
		$color = architek_hex2rgb(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color")));
		$architek_style_data .= "
		.load3 .loader{background:#".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).";background:-moz-linear-gradient(left, #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color")))." 10%, rgba(".esc_html($color[0].",".$color[1].",".$color[2]).", 0) 42%);background:-webkit-linear-gradient(left, #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color")))." 10%, rgba(".esc_html($color[0].",".$color[1].",".$color[2]).", 0) 42%);background:-o-linear-gradient(left, #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color")))." 10%, rgba(".esc_html($color[0].",".$color[1].",".$color[2]).", 0) 42%);background:-ms-linear-gradient(left, #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color")))." 10%, rgba(".esc_html($color[0].",".$color[1].",".$color[2]).", 0) 42%);background:linear-gradient(to right, #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color")))." 10%, rgba(".esc_html($color[0].",".$color[1].",".$color[2]).", 0) 42%);}
			
		.load6 .loader{font-size:50px;text-indent:-9999em;overflow:hidden;width:1em;height:1em;border-radius:50%;position:relative;-webkit-transform:translateZ(0);-ms-transform:translateZ(0);transform:translateZ(0);-webkit-animation:load6 1.7s infinite ease;animation:load6 1.7s infinite ease}@-webkit-keyframes 'load6'{0%{-webkit-transform:rotate(0deg);transform:rotate(0deg);box-shadow:0 -0.83em 0 -0.4em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", 0 -0.83em 0 -0.42em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", 0 -0.83em 0 -0.44em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", 0 -0.83em 0 -0.46em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", 0 -0.83em 0 -0.477em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).";}5%,95%{box-shadow:0 -0.83em 0 -0.4em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", 0 -0.83em 0 -0.42em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", 0 -0.83em 0 -0.44em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", 0 -0.83em 0 -0.46em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", 0 -0.83em 0 -0.477em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).";}10%,59%{box-shadow:0 -0.83em 0 -0.4em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", -0.087em -0.825em 0 -0.42em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", -0.173em -0.812em 0 -0.44em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", -0.256em -0.789em 0 -0.46em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", -0.297em -0.775em 0 -0.477em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).";}20%{box-shadow:0 -0.83em 0 -0.4em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", -0.338em -0.758em 0 -0.42em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", -0.555em -0.617em 0 -0.44em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", -0.671em -0.488em 0 -0.46em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", -0.749em -0.34em 0 -0.477em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).";}38%{box-shadow:0 -0.83em 0 -0.4em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", -0.377em -0.74em 0 -0.42em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", -0.645em -0.522em 0 -0.44em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", -0.775em -0.297em 0 -0.46em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", -0.82em -0.09em 0 -0.477em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).";}100%{-webkit-transform:rotate(360deg);transform:rotate(360deg);box-shadow:0 -0.83em 0 -0.4em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", 0 -0.83em 0 -0.42em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", 0 -0.83em 0 -0.44em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", 0 -0.83em 0 -0.46em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", 0 -0.83em 0 -0.477em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).";}}@keyframes 'load6'{0%{-webkit-transform:rotate(0deg);transform:rotate(0deg);box-shadow:0 -0.83em 0 -0.4em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", 0 -0.83em 0 -0.42em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", 0 -0.83em 0 -0.44em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", 0 -0.83em 0 -0.46em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", 0 -0.83em 0 -0.477em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).";}5%,95%{box-shadow:0 -0.83em 0 -0.4em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", 0 -0.83em 0 -0.42em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", 0 -0.83em 0 -0.44em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", 0 -0.83em 0 -0.46em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", 0 -0.83em 0 -0.477em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).";}10%,59%{box-shadow:0 -0.83em 0 -0.4em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", -0.087em -0.825em 0 -0.42em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", -0.173em -0.812em 0 -0.44em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", -0.256em -0.789em 0 -0.46em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", -0.297em -0.775em 0 -0.477em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).";}20%{box-shadow:0 -0.83em 0 -0.4em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", -0.338em -0.758em 0 -0.42em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", -0.555em -0.617em 0 -0.44em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", -0.671em -0.488em 0 -0.46em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", -0.749em -0.34em 0 -0.477em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).";}38%{box-shadow:0 -0.83em 0 -0.4em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", -0.377em -0.74em 0 -0.42em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", -0.645em -0.522em 0 -0.44em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", -0.775em -0.297em 0 -0.46em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", -0.82em -0.09em 0 -0.477em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).";}100%{-webkit-transform:rotate(360deg);transform:rotate(360deg);box-shadow:0 -0.83em 0 -0.4em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", 0 -0.83em 0 -0.42em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", 0 -0.83em 0 -0.44em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", 0 -0.83em 0 -0.46em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).", 0 -0.83em 0 -0.477em #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_color"))).";}}";
		
		if (get_option("architek_enable_website_loader_percentage") == "on"){
			$architek_style_data .= "
			body #architek_website_load .percentage{";
				$font = get_option("architek_loader_percentage_font"); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; if (!isset($font[1])) $font[1] = "";
				$architek_style_data .= "
				font-family: '".wp_kses($font[0], 'post')."', sans-serif;
				font-weight: ".esc_html($font[1]).";
				font-size: ".esc_html(intval(get_option("architek_loader_percentage_font_size"),10))."px;
				color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_loader_percentage_font_color"))).";
			}
			";
		}
	}
	
	$architek_style_data .= "
	.architek_breadcrumbs, .architek_breadcrumbs a, .architek_breadcrumbs span{";
		$font = get_option("architek_breadcrumbs_font"); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; 		if (!isset($font[1])) $font[1] = "";
		$architek_style_data .= "
		font-family: '".wp_kses($font[0], 'post')."';
		font-weight: ".esc_html($font[1]).";
		color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_breadcrumbs_color"))).";
		font-size: ".esc_html(intval(get_option("architek_breadcrumbs_size"),10))."px;
	}

	#menu_top_bar > li ul{background: #".str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_topbar_submenu_bg_color")).";}
	#menu_top_bar > li ul li:hover{background: #".str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_topbar_submenu_bg_hover_color")).";}
	#menu_top_bar > li ul a{color: #".str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_topbar_submenu_text_color"))." !important;}
	#menu_top_bar > li ul a:hover, #menu_top_bar > li ul li:hover > a{color: #".esc_html(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_topbar_submenu_text_hover_color")))." !important;}
	
	header.navbar .nav-container .architek_right_header_icons .icon,
	header .menu-controls .icon, header.style2 span.social_container i, header .menu-controls .icon, header .social_container i,
	header.style4 .architek_dynamic_shopping_bag .dripicons-cart,
	header.style4 .search_trigger .dripicons-search{color: #". str_replace( "__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_header_icons_color_".$architek_header_bgstyle_pre) )." !important;}
	
	header.navbar .hamburguer-trigger-menu-icon span{ 
		background-color: #".str_replace( "__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_header_icons_color_".$architek_header_bgstyle_pre) ).";
	}
	
	header.style6 .cd-nav-trigger .cd-icon, header.style6 .cd-nav-trigger .cd-icon::before, header.style6 .cd-nav-trigger .cd-icon:after{background-color:#". str_replace( "__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_header_icons_color_".$architek_header_bgstyle_pre) )." !important;}
	
		
	.header-style6-panel-open header.style6 .cd-nav-trigger .cd-icon, 
	.header-style6-panel-open header.style6 .cd-nav-trigger .cd-icon::before, 
	.header-style6-panel-open header.style6 .cd-nav-trigger .cd-icon:after{
		background-color: #ffffff !important;
	}
	
	header.navbar .nav-container .architek_right_header_icons .icon:hover,
	header .menu-controls .architek_right_header_icons .icon:hover, header.style2 span.social_container:hover i, header .social_container:hover i,
		header.style4 .architek_dynamic_shopping_bag .dripicons-cart:hover,
		header.style4 .search_trigger .dripicons-search:hover{color: #". str_replace( "__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_header_icons_hover_color_".$architek_header_bgstyle_pre) )." !important;}
	
	header.header_after_scroll.navbar .nav-container .architek_right_header_icons .icon, header .menu-controls .architek_right_header_icons .icon, header.header_after_scroll .social_container i{color: #". str_replace( "__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_header_after_scroll_icons_color_".$architek_header_bgstyle_after) )." !important;}
	
	header.header_after_scroll.navbar .hamburguer-trigger-menu-icon span{
		background-color: #".str_replace( "__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_header_after_scroll_icons_color_".$architek_header_bgstyle_after) ).";
	}

	header.header_after_scroll.navbar .nav-container .architek_right_header_icons .icon:hover, header .menu-controls .architek_right_header_icons .icon:hover, header.header_after_scroll .social_container:hover i{color: #".esc_html( str_replace( "__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_header_after_scroll_icons_hover_color_".$architek_header_bgstyle_after) ))." !important;}
	
	
	
	.cd-overlay-content span, .cd-nav-bg-fake{}
	
	";
	
	
	//sliding panel
	$architek_style_data .= "
		.architek-push-sidebar.architek-push-sidebar-right,
		.architek-push-sidebar-content .contact-form input[type='text'], 
		.architek-push-sidebar-content .contact-form input[type='email'],
		.architek-push-sidebar-content .contact-widget-container textarea{background-color:#".str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_sliding_panel_background_color"))." !important;}
		
		.architek-push-sidebar .widget h2 > .widget_title_span, .architek-push-sidebar .wpb_content_element .wpb_accordion_header a, .architek-push-sidebar .custom-widget h4, .architek-push-sidebar .widget.des_cubeportfolio_widget h4, .architek-push-sidebar .widget.des_recent_posts_widget h4, .architek-push-sidebar, .architek-push-sidebar .widget h4, .architek-push-sidebar h4, .architek-push-sidebar .widget h2 > .widget_title_span a.rsswidget{
			";
			$font = get_option("architek_sliding_panel_titles_font"); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; if (!isset($font[1])) $font[1] = "";
			$architek_style_data .= "
			font-family: '".wp_kses($font[0], 'post')."';
			font-weight: ".esc_html($font[1]).";
			color: #".str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_sliding_panel_titles_color"))." !important;
			font-size: ".esc_html(intval(get_option("architek_sliding_panel_titles_font_size"),10))."px;
		}
		
		.architek-push-sidebar .hamburguer-trigger-menu-icon.sidebar-opened{
			background-color: #".str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_sliding_panel_titles_color"))." !important;
		}
		
		.architek-push-sidebar a:not(.vc_btn3),
		.architek-push-sidebar .select2-container--default .select2-results__option[data-selected=true],
		.architek-push-sidebar .select2-results__option,
		#architek-push-sidebar-content ul li{
			";
			$font = get_option("architek_sliding_panel_links_font"); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; if (!isset($font[1])) $font[1] = "";
			$architek_style_data .= "
			font-family: '".wp_kses($font[0], 'post')."';
			font-weight: ".esc_html($font[1]).";
			color: #".str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_sliding_panel_links_color"))." !important;
			font-size: ".esc_html(intval(get_option("architek_sliding_panel_links_font_size"),10))."px;
		}
		
		
		.architek-push-sidebar p,
		.architek-push-sidebar .widget ul li,
		.architek-push-sidebar .widget span,
		architek-push-sidebar-content .contact-form input,
.architek-push-sidebar-content .contact-form input:not(.submit), 

		.architek-push-sidebar-content .contact-widget-container textarea
		{
			";
			$font = get_option("architek_sliding_panel_p_font"); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; if (!isset($font[1])) $font[1] = "";
			$architek_style_data .= "
			font-family: '".wp_kses($font[0], 'post')."';
			font-weight: ".esc_html($font[1]).";
			color: #".str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_sliding_panel_p_color"))." !important;
			font-size: ".esc_html(intval(get_option("architek_sliding_panel_p_font_size"),10))."px;
			
		}
		
		.architek-push-sidebar-content input[placeholder]::placeholder, .architek-push-sidebar-content input[placeholder]::-webkit-input-placeholder{";
			$font = get_option("architek_sliding_panel_p_font"); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; if (!isset($font[1])) $font[1] = "";
			$architek_style_data .= "
			font-family: '".wp_kses($font[0], 'post')."' !important;
			font-weight: ".esc_html($font[1])." !important;
			color: #".str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_sliding_panel_p_color"))." !important;
			font-size: ".esc_html(intval(get_option("architek_sliding_panel_p_font_size"),10))."px !important;
		}
		
		.architek-push-sidebar-content input[type],
		.architek-push-sidebar-content textarea{";
			$color = architek_hex2rgb(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_sliding_panel_p_color")));
			$architek_style_data .= "
			border: 1px solid rgba(".esc_html($color[0].",".$color[1].",".$color[2]).",.5) !important;
		}
		
		
		.architek-push-sidebar-content .widget_nav_menu li:first-child{border:none !important;}
		
	";
	
	/* new typography stuffs */
	$architek_style_data .= "
		.widget h2 > .widget_title_span, .custom-widget h4, .widget.des_cubeportfolio_widget h4, .widget.des_recent_posts_widget > h4, .sidebar .widget > h4,.widget .widget-contact-content > h4, .widget h2 > .widget_title_span a.rsswidget{
			";
			$font = get_option('architek_widgets_sidebars_font'); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; if (!isset($font[1])) $font[1] = "";
			$architek_style_data.= "
			font-family: '".wp_kses($font[0], 'post')."';
			font-weight: ".esc_html($font[1]).";
			color: #".str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_widgets_sidebars_color")).";
			font-size: ".esc_html(intval(get_option("architek_widgets_sidebars_size"),10))."px;
		}
		
		#big_footer .widget h2 > .widget_title_span, #big_footer .custom-widget h4, #big_footer .widget.des_cubeportfolio_widget h4, #big_footer .widget.des_recent_posts_widget > h4, #primary_footer .footer_sidebar > h4, #primary_footer .widget h4, #primary_footer .widget .widget-contact-content h4, #big_footer .widget h2 > .widget_title_span a.rsswidget, #primary_footer .footer_sidebar > h4 a.rsswidget, #primary_footer .footer_sidebar h4.widget_title_span{
			";
			$font = get_option('architek_widgets_footer_font'); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; if (!isset($font[1])) $font[1] = "";
			$architek_style_data.= "
			font-family: '".wp_kses($font[0], 'post')."';
			font-weight: ".esc_html($font[1]).";
			font-size: ".esc_html(intval(get_option("architek_widgets_footer_size"),10))."px !important;
		}
		
		#architek-push-sidebar-content .widget h2 > .widget_title_span, #architek-push-sidebar-content .custom-widget h4, #architek-push-sidebar-content .widget.des_cubeportfolio_widget h4, #architek-push-sidebar-content .widget.des_recent_posts_widget h4, #architek-push-sidebar-content .widget h2 > .widget_title_span a.rsswidget{
			";
			$font = get_option('architek_widgets_sliding_panel_font'); if (is_array($font)) $font = ""; $architek_import_fonts[] = $font; $font = explode("|",$font); $font[0] = $font[0]."', 'Arial', 'sans-serif"; if (!isset($font[1])) $font[1] = "";
			$architek_style_data.= "
			font-family: '".wp_kses($font[0], 'post')."';
			font-weight: ".esc_html($font[1]).";
			font-size: ".esc_html(intval(get_option("architek_widgets_sliding_panel_size"),10))."px;
		}
	";
	
	/* 2020 layout grid lines */
	if (get_option('architek_layout_grid_lines_enable','off') == 'on'){
		$architek_style_data .= " .body-line:not(:first-child)::after{ ";
		$color = architek_hex2rgb(str_replace("__USE_THEME_MAIN_COLOR__", $architek_color_code, get_option("architek_layout_grid_lines_color")));
		$architek_style_data .= "background-color: rgba(".esc_html($color[0].",".$color[1].",".$color[2].",".intval(str_replace("%","",get_option("architek_layout_grid_lines_opacity")))/100).") !important;
		} ";
	}
	
	if (get_option("enable_custom_css") == "on"){
		$architek_customcss = get_option("architek_custom_css");
		if (gettype($architek_customcss) === "string" && $architek_customcss != "") {
			$architek_style_data .= stripslashes($architek_customcss);
		}
	}

	wp_add_inline_style('architek-style', str_replace(array("\r", "\n"), '', trim(preg_replace('/\t+/', '', $architek_style_data))));
	
}
add_action( 'wp_enqueue_scripts', 'architek_custom_style', 2 );

?>