<?php

function architek_print_woocommerce_button(){
	global $woocommerce;
	if (isset($woocommerce) && get_option("architek_woocommerce_cart") == "on"){ ?>
		<div class="architek_dynamic_shopping_bag">
			<div class="architek_little_shopping_bag_wrapper">
				<div class="architek_little_shopping_bag">
					<div class="title">
						<div class="icon dripicons-basket"></div>
					</div>
					<div class="overview">
						<span class="minicart_items"><?php echo sprintf(_n('%d', '%d', $woocommerce->cart->cart_contents_count, 'architek'), $woocommerce->cart->cart_contents_count); ?></span>
					</div>
				</div>
				<div class="architek_minicart_wrapper">
					<div class="architek_minicart">
					<?php
						if (sizeof($woocommerce->cart->cart_contents)>0){
							echo '<ul class="cart_list">';
							foreach ($woocommerce->cart->cart_contents as $cart_item_key => $cart_item){
								$_product = $cart_item['data'];
								if ($_product->exists() && $cart_item['quantity']>0){
									echo '<li class="cart_list_product">';
										echo '<a class="cart_list_product_img" href="'.esc_url(get_permalink($cart_item['product_id'])).'">' . $_product->get_image().'</a>';
										echo '<div class="cart_list_product_title">';
											$architek_product_title = $_product->get_title();
											$architek_short_product_title = (strlen($architek_product_title) > 28) ? substr($architek_product_title, 0, 25) . '...' : $architek_product_title;
											echo '<a href="'.esc_url(get_permalink($cart_item['product_id'])).'">' . apply_filters('woocommerce_cart_widget_product_title', $architek_short_product_title, $_product) . '</a>';
											echo '<div class="cart_list_product_quantity">'.$cart_item['quantity'].'x</div>';
										echo '</div>';
										echo apply_filters( 'woocommerce_cart_item_remove_link', sprintf('<a href="%s" class="remove" title="%s">x</a>', esc_url( wc_get_cart_remove_url( $cart_item_key ) ), esc_html__('Remove this item', 'architek') ), $cart_item_key );
										echo '<div class="cart_list_product_price">'.wc_price($_product->get_price()).'</div>';
										echo '<div class="clr"></div>';
									echo '</li>';
								}
							}
							echo '</ul>';
							?>
							<div class="minicart_total_checkout">
							<?php esc_html_e('Cart subtotal', 'architek'); ?><span><?php echo wp_kses($woocommerce->cart->get_cart_total(), 'post'); ?></span>
							</div>
							<a href="<?php echo esc_url( wc_get_cart_url() ); ?>" class="button architek_minicart_cart_but"><?php esc_html_e('View Bag', 'architek'); ?></a>
							<a href="<?php echo esc_url( wc_get_checkout_url() ); ?>" class="button architek_minicart_checkout_but"><?php esc_html_e('Checkout', 'architek'); ?></a>
							<?php
						} else {
							echo '<ul class="cart_list"><li class="empty">'.esc_html__('No products in the cart.','architek').'</li></ul>';
						}
						?>
					</div>
				</div>
			</div>
			<a href="<?php echo esc_url( wc_get_cart_url() ); ?>" class="architek_little_shopping_bag_wrapper_mobiles"><span><?php echo wp_kses($woocommerce->cart->cart_contents_count, 'post'); ?></span></a>
		</div>
	<?php
	}
}

function architek_woocommerce_header_add_to_cart_fragment( $fragments ) {
	global $woocommerce;
	if (isset($woocommerce) && get_option("architek_woocommerce_cart") == "on"){
		$architek_woo_output = '
		<div class="architek_dynamic_shopping_bag">
			<div class="architek_little_shopping_bag_wrapper">
				<div class="architek_little_shopping_bag">
					<div class="title">
						<div class="icon dripicons-basket"></div>
					</div>
					<div class="overview">
						<span class="minicart_items">'.sprintf(_n('%d', '%d', $woocommerce->cart->cart_contents_count, 'architek'), $woocommerce->cart->cart_contents_count).'</span>
					</div>
				</div>
				<div class="architek_minicart_wrapper">
					<div class="architek_minicart">';
						if (sizeof($woocommerce->cart->cart_contents)>0){
							$architek_woo_output .= '<ul class="cart_list">';
							foreach ($woocommerce->cart->cart_contents as $cart_item_key => $cart_item){
								$_product = $cart_item['data'];
								if ($_product->exists() && $cart_item['quantity']>0){
									$architek_woo_output .= '<li class="cart_list_product">';
										$architek_woo_output .= '<a class="cart_list_product_img" href="'.esc_url(get_permalink($cart_item['product_id'])).'">' . $_product->get_image().'</a>';
										$architek_woo_output .= '<div class="cart_list_product_title">';
											$architek_product_title = $_product->get_title();
											$architek_short_product_title = (strlen($architek_product_title) > 28) ? substr($architek_product_title, 0, 25) . '...' : $architek_product_title;
											$architek_woo_output .= '<a href="'.esc_url(get_permalink($cart_item['product_id'])).'">' . apply_filters('woocommerce_cart_widget_product_title', $architek_short_product_title, $_product) . '</a>';
											$architek_woo_output .= '<div class="cart_list_product_quantity">'.$cart_item['quantity'].'x</div>';
										$architek_woo_output .= '</div>';
										$architek_woo_output .= apply_filters( 'woocommerce_cart_item_remove_link', sprintf('<a href="%s" class="remove" title="%s">x</a>', esc_url( wc_get_cart_remove_url( $cart_item_key ) ), esc_html__('Remove this item', 'architek') ), $cart_item_key );
										$architek_woo_output .= '<div class="cart_list_product_price">'.wc_price($_product->get_price()).'</div>';
										$architek_woo_output .= '<div class="clr"></div>';
									$architek_woo_output .= '</li>';
								}
							}
							$architek_woo_output .= '</ul>';
							$architek_woo_output .= '
							<div class="minicart_total_checkout">
								'.esc_html__('Cart subtotal', 'architek').'<span>'.wp_kses($woocommerce->cart->get_cart_total(), 'post').'</span>
						</div>
						<a href="'.esc_url( wc_get_cart_url() ).'" class="button architek_minicart_cart_but">'.esc_html__('View Bag', 'architek').'</a>
						<a href="'.esc_url( wc_get_checkout_url() ).'" class="button architek_minicart_checkout_but">'. esc_html__('Checkout', 'architek').'</a>';
						} else {
							$architek_woo_output .= '<ul class="cart_list"><li class="empty">'.esc_html__('No products in the cart.','architek').'</li></ul>';
						}
						$architek_woo_output .= '
					</div>
				</div>
			</div>
			<a href="'.esc_url( wc_get_cart_url() ).'" class="architek_little_shopping_bag_wrapper_mobiles"><span>'. wp_kses($woocommerce->cart->cart_contents_count, 'post').'</span></a>
		</div>';
		$fragments['div.architek_dynamic_shopping_bag'] = $architek_woo_output;
		return $fragments;
	} else return "";
}

?>